from pyzx.simplify import simp
from pyzx.rules import (
    w_fusion,
    match_w_fusion_parallel,
    z_to_z_box,
    match_z_to_z_box_parallel,
)

from pyzx.graph.base import BaseGraph, ET, VT


def w_fusion_simp(g: BaseGraph[VT, ET], quiet: bool) -> int:
    return simp(g, "w-fusion_simp", match_w_fusion_parallel, w_fusion, quiet=quiet)


def z_to_z_box_simp(g: BaseGraph[VT, ET], quiet: bool) -> int:
    return simp(
        g, "z-to-z-box_simp", match_z_to_z_box_parallel, z_to_z_box, quiet=quiet
    )
