"""
BFS
"""

import qiskit as qk
from qiskit import QuantumCircuit
from qiskit.transpiler import PassManager
from qiskit.transpiler.passes import Unroll3qOrMore

import pyzx as zx
from pyzx.graph.base import BaseGraph, VT, ET
from pyzx.circuit import Circuit
from pyzx import extract_circuit

from typing import Tuple, Callable, Any, Self

from queue import Queue

from copy import deepcopy
from copy import copy

from multiprocessing import Process, Lock, cpu_count, Value, shared_memory, Manager
from multiprocessing.managers import BaseManager

from full_analysis import full_analysis

from algorithms.pyzx import pyzx_full_reduce

from dataclasses import dataclass, make_dataclass, fields
import dill
import datetime as DT
from datetime import datetime, timedelta
from queue import Queue
from pyzx.simplify import is_graph_like, to_graph_like

from .dfs import DFS, Result, AllResults, get_circuit_statistics, zx_rules


class BFS(DFS):
    # main method of the class that performs the optimization
    def run(self) -> AllResults:

        dic_root: dict = self._setup()

        s: Queue = Queue()  # LIFO is stack for dfs
        s.put(deepcopy(dic_root))

        # compute maximum allowed runtime of dfs
        if self.b_max_duration:
            end_time: datetime = datetime.now() + timedelta(seconds=self.max_duration)

        # compute initial time for first snapshot
        if self.b_snapshot:
            prefix_cntr: int = 0

            # dump initial snapshot and update all results
            if self.b_snapshot_pkl:
                self._snapshot_results(prefix_cntr)

            # generate initial snapshot csv file with solution overview
            time_stamp: datetime = datetime.now()
            self._snapshot_csv(prefix_cntr, time_stamp, force=True)

            # generate time when next snapshot should be executed
            next_snapshot: datetime = datetime.now() + timedelta(
                seconds=self.snapshot_frequency
            )

        while s.qsize() > 0:
            dic_stack = s.get()

            # terminate dfs if maximum allowed runtime was reached
            if self.b_max_duration:
                current_time: datetime = datetime.now()
                if current_time > end_time:
                    break

            # execute snapshot
            if self.b_snapshot:
                time_stamp: datetime = datetime.now()
                if time_stamp > next_snapshot:
                    # dump snapshot and update all results
                    if self.b_snapshot_pkl:
                        self._snapshot_results(prefix_cntr)

                    # generate snapshot csv file with solution overview
                    self._snapshot_csv(prefix_cntr, time_stamp)

                    # update when next snapshot should be executed
                    next_snapshot: datetime = datetime.now() + timedelta(
                        seconds=self.snapshot_frequency
                    )

                    # update prefix_cntr
                    prefix_cntr += 1

            for rule in self.l_zx_rules:

                # get a dictionary with all parameters of currentliy visited node
                dic_child, node = self._get_current_node(rule, dic_stack)

                # get depth of current of current node
                if self.b_trace_depth:
                    current_depth = dic_child["cntr_max_depth"]
                else:
                    current_depth = None

                # terminate tree based tree or rule pruning conditions
                if self._check_pruning_conditions_tree_rule(dic_stack, dic_child, rule):
                    continue

                # apply rule to graph
                child_graph = deepcopy(dic_stack["g"])
                if not is_graph_like(child_graph):
                    to_graph_like(child_graph)

                cntr = rule(child_graph, quiet=self.b_quiet)

                # terminate tree based on circuit pruning conditions
                if self._check_pruning_conditions_circuit(
                    deepcopy(child_graph), node, current_depth
                ):
                    continue

                # explore node propterties at every node of the tree
                if self.b_check_every_node:
                    try:
                        self._explore_node(deepcopy(child_graph), node, current_depth)
                    except Exception:
                        pass

                # push to stack if rule can still be applied
                if cntr > 0:
                    dic_child["g"] = deepcopy(child_graph)
                    s.put(deepcopy(dic_child))

                # explore node properties at leaf node
                else:
                    if self.b_trace_leafs:
                        self.n_leafs += 1
                    try:
                        self._explore_node(deepcopy(child_graph), node, current_depth)
                    except Exception:
                        pass

        # check global optimality
        if self.b_max_duration:
            if end_time < current_time:
                self.AllResults.optimal = False
            else:
                if not self.b_kill_optimal:
                    self.AllResults.optimal = True
        else:
            if not self.b_kill_optimal:
                self.AllResults.optimal = True
            else:
                self.AllResults.optimal = False

        # compute initial time for first snapshot
        if self.b_snapshot:
            # differentiate between inital and final snapshot if dfs finishes inside the first window
            if prefix_cntr == 0:
                prefix_cntr = 1

            # dump initial snapshot and update all results
            if self.b_snapshot_pkl:
                self._snapshot_results(prefix_cntr)

            # generate initial snapshot csv file with solution overview
            time_stamp: datetime = datetime.now()
            self._snapshot_csv(prefix_cntr, time_stamp, force=True)

        # update and save results from dfs
        self._save_results()

        return self.AllResults
