import pytest
import os  # allow imports
import sys
from typing import Callable

parent_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
for module_folder in ["algorithms", "benchmark", "zx_dfs", "statistics", "bin"]:
    sys.path.append(f"{parent_dir}/{module_folder}")
else:
    sys.path.append(f"{parent_dir}")

from qiskit import QuantumCircuit

from benchmark.run_benchmark import get_circuit_statistics, get_circuit_name

from zx_dfs.dfs import AllResults
from algorithms.dfs import *
from benchmark.statistics import get_circuit_name, get_circuit_statistics


l_circuits = [
    "../circuits/xor5d1.qasm",
    "../circuits/graycode6.qasm",
    "../circuits/ham3tc.qasm",
    "../circuits/3_17tc.qasm",
]


@pytest.mark.paramentize("circuit", circuits)
def test_dfs(circuit):
    qc: QuantumCircuit = QuantumCircuit.from_qasm_file(circuit)
    name: str = get_circuit_name(circuit)
    result: AllResults = dfs(qc, circ_name=name)
    assert True


def test_idfs():
    pass


def test_bfs():
    pass


def test_ibfs():
    pass
