#!/usr/bin/env -S bash -l

build=0

while getopts "b" opt; do
  case "$opt" in
    b)  build=1; shift ;;
    *)  echo "invalid argument" && exit 1
  esac
done

home_cluster=/home/users/tfischbach
path_to_repo=${HOME}/zx_dfs
cd ${path_to_repo} || exit
if [[ ${build} -eq 1 ]]; then
  nix build .#docker-run.x86_64-linux
  cp -fv result zx_dfs.tar.gz
fi

cd .. || exit
rsync -vahzu --rsh='ssh -p 8022' zx_dfs tfischbach@access-aion.uni.lu:${home_cluster}/
 

if [[ ${build} -eq 1 ]]; then
  ssh -p 8022 tfischbach@access-iris.uni.lu -t sbatch "${home_cluster}/zx_dfs/slurm/slurm_build_singularity.sh"
fi
