#!/bin/env -S bash -l                # <--- DO NOT FORGET '-l'
### Request a single task using one core on one node for 5 minutes in the batch queue
#SBATCH -N 1
#SBATCH --ntasks-per-node=1
#SBATCH -c 112
#SBATCH --time=2-00:00:00
#SBATCH -p bigmem
module load tools/Singularity/3.8.1

path_to_docker=/home/users/tfischbach/zx_dfs
path_to_data=/home/users/tfischbach/verification
mkdir -p ${path_to_data}

function gen_metadata() {

  git_repo="$1"
  cd "${git_repo}"
  git_hash=$(git log -1 --format=%H)
  git_remote=$(git remote -v | awk '{print $2}' | uniq )
  git_message=$(git log -1 --pretty=%B)
  cd - &> /dev/null

  echo "=== METADATA ==="
  echo -e "Git-hash:\t${git_hash}" 
  echo -e "Git-local:\t${git_repo}" 
  echo -e "Git-remote:\t${git_remote}"
  echo -e "Git-message:\t${git_message}"

}

function gen_dir_name() {
  git_repo="$1"
  cd ${git_repo}
  git_hash=$(git log -1 --format=%H)
  git_message=$(git log -1 --pretty=%B | sed 's/^[0-9]*-[0-9]*-[0-9]*//g' | sed 's/^\s*//g' | sed 's/ /-/g')
  dir_name="$(date +%Y-%m-%d)_${git_hash}_${git_message}"
  cd - &> /dev/null
  echo ${dir_name}
}

dir_name=$(gen_dir_name ${path_to_docker})

cd ${path_to_data} || exit 1
if [ -d ${dir_name} ]; then
  path_to_data="${path_to_data}/${dir_name}"
  cd ${path_to_data} || exit 1

else
  # get newset dir instead 
  dir_name=$(ls -td * | head -1)
  path_to_data="${path_to_data}/${dir_name}"
  cd ${path_to_data} || exit 1
  echo "YAY"
fi

# Add Metadata
gen_metadata ${path_to_docker} > ${path_to_data}/VERIFICATION.log

# verify circuits
echo "=== Circuit Verify ===" >> ${path_to_data}/VERIFICATION.log
cd ${path_to_docker}
singularity run --bind ${path_to_data}:/data zx_dfs.sif -c "cd bin/ ; python test_benchmark.py -f /data/*.pkl --circuit &>> /data/VERIFICATION.log" 

# use graph verification where the easier circuit verification failed
echo "=== Graph Verify ===" >> ${path_to_data}/VERIFICATION.log
grep "False" ${path_to_data}/VERIFICATION.log | awk '{print $3}' | xargs -I % singularity run --bind ${path_to_data}:/data zx_dfs.sif -c "cd bin/ ; python test_benchmark.py -f % --graph &>> /data/VERIFICATION.log" 
