#!/bin/env -S bash -l                # <--- DO NOT FORGET '-l'
### Request a single task using one core on one node for 5 minutes in the batch queue
#SBATCH -N 1
#SBATCH --ntasks-per-node=1
#SBATCH -c 112
#SBATCH --time=2-00:00:00
#SBATCH -p bigmem
module load tools/Singularity/3.8.1

path_to_docker=/home/users/tfischbach/zx_dfs
path_to_data=/home/users/tfischbach/verification_run
cd ${path_to_docker} && cd ${path_to_docker} || exit

# build docker container based on 
#singularity build --force zx_dfs.sif docker-archive://zx_dfs.tar.gz 

mkdir -p ${path_to_data}

# run small benchmark
#singularity run --bind ${path_to_data}:/data zx_dfs.sif
#
# verify circuits
echo "=== Circuit Verify ===" > ${path_to_data}/VERIFICATION.log
singularity run --bind ${path_to_data}:/data zx_dfs.sif -c "cd bin/ ; python test_benchmark.py -f /data/*.pkl --circuit &>> /data/VERIFICATION.log" 

# use graph verification where the easier circuit verification failed
echo "=== Graph Verify ===" >> ${path_to_data}/VERIFICATION.log
grep "False" ${path_to_data}/VERIFICATION.log | awk '{print $3}' | xargs -I % singularity run --bind ${path_to_data}:/data zx_dfs.sif -c "cd bin/ ; python test_benchmark.py -f % --graph &>> /data/VERIFICATION.log" 
