#!/bin/env -S bash -l                # <--- DO NOT FORGET '-l'
#SBATCH -N 1
#SBATCH --ntasks-per-node=1
#SBATCH -c 28
#SBATCH --time=2-00:00:00
#SBATCH -p batch

module load tools/Singularity/3.8.1

path_to_docker=/home/users/tfischbach/zx_dfs
path_to_data=/home/users/tfischbach/ola
mkdir -p ${path_to_data}

function gen_metadata() {

  git_repo="$1"
  cd "${git_repo}"
  git_hash=$(git log -1 --format=%H)
  git_remote=$(git remote -v | awk '{print $2}' | uniq )
  git_message=$(git log -1 --pretty=%B)
  cd - &> /dev/null

  echo "=== METADATA ==="
  echo -e "Git-hash:\t${git_hash}" 
  echo -e "Git-local:\t${git_repo}" 
  echo -e "Git-remote:\t${git_remote}"
  echo -e "Git-message:\t${git_message}"

}

function gen_dir_name() {
  git_repo="$1"
  cd ${git_repo}
  git_hash=$(git log -1 --format=%H)
  git_message=$(git log -1 --pretty=%B | sed 's/^[0-9]*-[0-9]*-[0-9]*//g' | sed 's/^\s*//g' | sed 's/ /-/g')
  dir_name="$(date +%Y-%m-%d-%H-%M-%S)_${git_hash}_${git_message}"
  cd - &> /dev/null
  echo ${dir_name}
}

dir_name=$(gen_dir_name ${path_to_docker})
path_to_data="${path_to_data}/${dir_name}"
mkdir -p ${path_to_data}


# Add Metadata
gen_metadata "${path_to_docker}" > "${path_to_data}"/RUN.log
cp -rv ~/zx_dfs/* ${path_to_data}/ >> "${path_to_data}"/RUN.log


# Run full benchmarks
echo "=== Full BENCHMARK ===" >> "${path_to_data}"/RUN.log
cd "${path_to_data}"
singularity run --bind "${path_to_data}":/data zx_dfs.sif -c "cd bin/; python run_benchmark_full.py; mv *.pkl *.csv /data/" &>> "${path_to_data}"/RUN.log
