{
  description = "Application packaged using poetry2nix";

  inputs = {
    flake-utils.url = "github:numtide/flake-utils";
    nixpkgs.url = "github:NixOS/nixpkgs/nixpkgs-unstable";
    poetry2nix = {
      url = "github:nix-community/poetry2nix";
      inputs.nixpkgs.follows = "nixpkgs";
    };
  };

  outputs = { self, nixpkgs, flake-utils, poetry2nix}:
    flake-utils.lib.eachDefaultSystem (system:
      let
        # see https://github.com/nix-community/poetry2nix/tree/master#api for more functions and examples.
        #pkgs = nixpkgs.legacyPackages.${system};
        pkgs = import nixpkgs {
          system = "${system}";

          hostPlatform = {
            gcc.arch = "skylake";
            gcc.tune = "skylake";
            system = "${system}";
          };

          overlays = [
            (self: super: {
              python311 = super.python31.override {
                enableOptimizations = true;
                reproducibleBuild = false;
              }; # allow more optimized python
            })
            (self: super: {
              python312 = super.python312.override {
                enableOptimizations = true;
                reproducibleBuild = false;
              }; # allow more optimized python
            })
          ];
        };


        shell-env = pkgs.mkShell {
          inputsFrom = [ self.packages.${system}.myapp ];
          packages = with pkgs; [
            poetry
            python312Packages.tkinter
            graphviz
            entr
            gnumake
            texliveFull
            texlivePackages.zx-calculus
            texlivePackages.quantikz
            black
            nix
          ];
        };
        inherit (poetry2nix.lib.mkPoetry2Nix { inherit pkgs; }) mkPoetryApplication mkPoetryEnv defaultPoetryOverrides;

      in
      {
        packages = {
          myapp = mkPoetryApplication {
            overrides = defaultPoetryOverrides.extend
              (self: super: {
                qiskit-ibm-runtime = super.qiskit-ibm-runtime.overridePythonAttrs
                  (
                    old: {
                      buildInputs = (old.buildInputs or [ ]) ++ [ super.setuptools ];
                    }
                  );
                ibm-platform-services = super.ibm-platform-services.overridePythonAttrs
                  (
                    old: {
                      buildInputs = (old.buildInputs or [ ]) ++ [ super.setuptools ];
                    }
                  );
              });

            projectDir = self;
            preferWheels = true;
          };
          python = pkgs.python312;
          default = self.packages.${system}.myapp;
        };

        docker-shell = pkgs.dockerTools.buildNixShellImage
          {
            name = "zx_dfs";
            tag = "latest";
            architecture = "${system}";
            homeDirectory = "/tmp";
            drv = shell-env;
          };

        docker-run = pkgs.dockerTools.buildLayeredImage {
          name = "zx_dfs";
          tag = "latest";
          contents = with pkgs; [
            self.packages.${system}.myapp.dependencyEnv
            poetry
            #python312Packages.tkinter
            coreutils-full
            gnumake
            bash
            ./.
          ];



          config = {
            Entrypoint = ["bash"];
            Volumes = {
              "/data" = {};
            };
            Workdir = "/bin";

            Cmd = ["-c" "cd bin/ ; python run_benchmark.py -f; mv -vf *.csv *.pkl /data/"];
          };

        };


        devShells.default = shell-env;
      });
}
