from tabulate import tabulate
import csv
import sys


def main():
    if len(sys.argv) < 2:
        print("Usage: python program_name.py <filename>")
        sys.exit(1)

    filename = sys.argv[1]
    data = read_csv_file(filename)
    table_creation(data)


def read_csv_file(filename):
    data = []
    with open(filename, "r") as file:
        csv_reader = csv.reader(file)
        for row in csv_reader:
            data.append(row)
    return data


def table_creation(data):
    table = tabulate(data, headers="firstrow", tablefmt="latex")
    print(table)


if __name__ == "__main__":
    main()
    print("Finished experiments")
