import pandas as pd
from pandas import DataFrame
from io import TextIOWrapper
import matplotlib.pyplot as plt
import matplotlib
import scienceplots

matplotlib.use("TkAgg")

csv: str = "./_results_checkpoint.csv"

f: TextIOWrapper = open(csv, "r")

l_lines: list[str] = [line.strip() for line in f.readlines()]
l_exps: list[dict] = []

for i in range(0, len(l_lines), 2):
    header: list[str] = l_lines[i].split(",")
    data: list[str] = l_lines[i + 1].split(",")
    l_exps.append({k: v for k, v in zip(header, data)})

df: DataFrame = pd.DataFrame(l_exps)
df[
    [
        "c_tcount",
        "q_num_qubits",
        "q_depth",
        "q_all_ops",
        "c_gates",
        "g_edges",
        "g_vertices",
    ]
] = df[
    [
        "c_tcount",
        "q_num_qubits",
        "q_depth",
        "q_all_ops",
        "c_gates",
        "g_edges",
        "g_vertices",
    ]
].apply(
    pd.to_numeric
)

df_filter: DataFrame = df[df["func_opt"] == "dfs"]
df_circuit_names: DataFrame = df_filter["circuit_name"]

l_func_order: list[str] = [
    "unoptimized",
    "pyzx_teleport_reduce",
    "pyzx_scalar_reduce",
    "pyzx_full_reduce",
    "dfs",
]

df_filter = df[df["circuit_name"].isin(df_circuit_names)]
df_plot: DataFrame = df_filter.pivot_table(
    index="circuit_name", columns="func_opt", values="c_gates"
)
df_plot = df_plot[l_func_order]


plt.style.use(["science", "nature"])

df_plot.plot(kind="bar")

plt.xticks(rotation=15)
plt.xlabel("Quantum Circuit")
plt.ylabel(r"$N_{\text{Qubit}}$")


plt.title("Gate count of different optimization strategies")
plt.legend(
    title="Optimization function", loc="upper left", ncol=1, bbox_to_anchor=(1.05, 1.05)
)

plt.savefig("gate_reduction.png", dpi=300, bbox_inches="tight", transparent=True)
