import os  # allow imports
import sys
from typing import Tuple

from pyzx.graph.base import BaseGraph, VT, ET
from pyzx.circuit import Circuit

parent_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
for module_folder in ["algorithms", "benchmark", "zx_dfs", "statistics", "bin"]:
    sys.path.append(f"{parent_dir}/{module_folder}")
else:
    sys.path.append(f"{parent_dir}")

from qiskit import QuantumCircuit

from benchmark.run_benchmark import get_circuit_statistics, get_circuit_name

from zx_dfs.bfs import BFS

from zx_dfs.dfs import (
    AllResults,
)


def bfs(
    qc: QuantumCircuit,
    circ_name: str | None,
    metric: list[str] = ["c_tcount", "c_gates", "g_vertices"],
    func_opt: str | None = None,
) -> AllResults:
    return BFS(
        qc,
        circ_name=circ_name,
        metric=metric,
        b_prune_colour_cycle=True,
        b_prune_non_circuits=True,
        b_prune_colour_change=True,
        func_opt=func_opt,
    ).run()


def bfs_no_colour_cycle(
    qc: QuantumCircuit,
    circ_name: str | None,
    metric: list[str] = ["c_tcount", "c_gates", "g_vertices"],
    func_opt: str | None = None,
) -> AllResults:
    return BFS(
        qc,
        circ_name=circ_name,
        metric=metric,
        b_prune_colour_cycle=True,
        func_opt=func_opt,
    ).run()


def bfs_limit_colour_change(
    qc: QuantumCircuit,
    circ_name: str | None,
    metric: list[str] = ["c_tcount", "c_gates", "g_vertices"],
    func_opt: str | None = None,
) -> AllResults:
    return BFS(
        qc,
        circ_name=circ_name,
        metric=metric,
        b_prune_colour_change=True,
        func_opt=func_opt,
    ).run()


def bfs_no_colour_cycle_kill_non_circuits(
    qc: QuantumCircuit,
    circ_name: str | None,
    metric: list[str] = ["c_tcount", "c_gates", "g_vertices"],
    func_opt: str | None = None,
) -> AllResults:
    return BFS(
        qc,
        circ_name=circ_name,
        metric=metric,
        b_prune_colour_cycle=True,
        b_prune_non_circuits=True,
        func_opt=func_opt,
    ).run()


def bfs_no_colour_cycle_limit_colour_change(
    qc: QuantumCircuit,
    circ_name: str | None,
    metric: list[str] = ["c_tcount", "c_gates", "g_vertices"],
    func_opt: str | None = None,
) -> AllResults:
    return BFS(
        qc,
        circ_name=circ_name,
        metric=metric,
        b_prune_colour_cycle=True,
        b_prune_colour_change=True,
        func_opt=func_opt,
    ).run()


def bfs_max_depth(
    qc: QuantumCircuit,
    circ_name: str | None,
    metric: list[str] = ["c_tcount", "c_gates", "g_vertices"],
    func_opt: str | None = None,
) -> AllResults:
    return BFS(
        qc,
        circ_name=circ_name,
        metric=metric,
        b_prune_max_depth=True,
        func_opt=func_opt,
    ).run()


def bfs_no_colour_cycle_max_depth(
    qc: QuantumCircuit,
    circ_name: str | None,
    metric: list[str] = ["c_tcount", "c_gates", "g_vertices"],
    func_opt: str | None = None,
) -> AllResults:
    return BFS(
        qc,
        circ_name=circ_name,
        metric=metric,
        b_prune_colour_cycle=True,
        b_prune_max_depth=True,
        func_opt=func_opt,
    ).run()


def bfs_strict_convergence(
    qc: QuantumCircuit,
    circ_name: str | None,
    metric: list[str] = ["c_tcount", "c_gates", "g_vertices"],
    func_opt: str | None = None,
) -> AllResults:
    return BFS(
        qc,
        circ_name=circ_name,
        metric=metric,
        b_prune_worse_circuits=True,
        func_opt=func_opt,
    ).run()
