/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class CedillaAtom
extends Atom {
    private Atom a;

    public CedillaAtom(Atom atom) {
        this.a = atom;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box;
        Box box2 = this.a.createBox(teXEnvironment);
        VerticalBox verticalBox = new VerticalBox();
        verticalBox.add(box2);
        Char char_ = teXEnvironment.getTeXFont().getChar("jlatexmathcedilla", teXEnvironment.getStyle());
        float f = char_.getItalic();
        CharBox charBox = new CharBox(char_);
        if (Math.abs(f) > 1.0E-7f) {
            box = new HorizontalBox(new StrutBox(-f, 0.0f, 0.0f, 0.0f));
            box.add(charBox);
        } else {
            box = charBox;
        }
        HorizontalBox horizontalBox = new HorizontalBox(box, box2.getWidth(), 2);
        float f2 = 0.4f * SpaceAtom.getFactor(5, teXEnvironment);
        verticalBox.add(new StrutBox(0.0f, -f2, 0.0f, 0.0f));
        verticalBox.add(horizontalBox);
        float f3 = verticalBox.getHeight() + verticalBox.getDepth();
        verticalBox.setHeight(box2.getHeight());
        verticalBox.setDepth(f3 - box2.getHeight());
        return verticalBox;
    }
}

