#######################
# R. Bisdorff
# pytest functions for the linearOrders module
# ..$python3 -m pip install pytest  # installing the pytest package
########################

from digraphs import *
from perfTabs import *
from outrankingDigraphs import *
from linearOrders import *
from decimal import Decimal

def testKemenyOrdering():
    print('*-------- Testing KemenyOrder class -------')
    t = RandomCBPerformanceTableau(numberOfActions=6)
    t.save('testKemeny')
    g = BipolarOutrankingDigraph(t)
    ke = KemenyOrder(g,Debug=True)
    print(ke.orderedMaximalRankings)

def testSlaterOrdering():
    print('*-------- Testing KemenyOrder class -------')
    t = RandomCBPerformanceTableau(numberOfActions=6)
    t.save('testKemeny')
    g = BipolarOutrankingDigraph(t)
    sl = SlaterOrder(g,Debug=True)

def testRankedPairsOrdering():
    print('*-------- Testing RankedPairsOrder class -------')
    t = RandomPerformanceTableau(numberOfActions=15)
    t.save()
    t.showPerformanceTableau()
    g = BipolarOutrankingDigraph(t)
    rp = RankedPairsOrder(g,Dual=False,Debug=True)
    rp.showRelationTable()
    rpd = RankedPairsOrder(g,Dual=True,Debug=False)
    rp.showRelationTable()
    rp.exportGraphViz('testorder')
    rp.exportDigraphGraphViz('testdigraph')

def testKohlerOrdering():
    print("*==>> testing KohlerOrder Class ----*")
    t = RandomCBPerformanceTableau(numberOfActions=15)
    t.saveXMCDA2('testkohler')
    g = BipolarOutrankingDigraph(t)
    #g.showRelationTable()
    k = KohlerOrder(g,Debug=True)
    print(k.computeOrder())

def testNetFlowsOrdering():
    print("*==>> testing NetFlowsOrder Class ----*")
    t = RandomCBPerformanceTableau(numberOfActions=15)
    t.saveXMCDA2('testnf')
    g = BipolarOutrankingDigraph(t)
    #g.showRelationTable()
    nfo = NetFlowsOrder(g,CoDual=False,Debug=True)
    print(nfo.computeOrder())

def testIteratedNetFlowsOrdering():
    print("*==>> testing iterated NetFlowsOrder Class ----*")
    t = RandomCBPerformanceTableau(numberOfActions=15)
    t.saveXMCDA2('testnf')
    g = BipolarOutrankingDigraph(t)
    #g.showRelationTable()
    info = IteratedNetFlowsRanking(g,CoDual=False,Debug=True)
    print(info.computeOrder())

def testRandomLinearOrders():
    print("*==>> testing RandomLinearOrder Class ----*")
    g1 = RandomLinearOrder(numberOfActions=10,Debug=True)
    g1.showRelationTable()
    g2 = RandomLinearOrder(numberOfActions=10,Debug=True)
    g2.showRelationTable()
    print(g1.computeBipolarCorrelation(g2))
    g1 = RandomLinearOrder(numberOfActions=10,OutrankingModel=True,Debug=True)
    g1.showRelationTable()
    g2 = RandomLinearOrder(numberOfActions=10,OutrankingModel=True,Debug=True)
    g2.showRelationTable()
    print(g1.computeBipolarCorrelation(g2))

def testRankingCorrelations():
    print('*-------- Testing ranking qualities -------')
    from linearOrders import _OutFlowsOrder
    t = RandomCBPerformanceTableau(numberOfActions=7,numberOfCriteria=5,seed=100)
    g = BipolarOutrankingDigraph(t,Normalized=True)
    g.showRelationTable()
    print()
    print('==>> Kemeny ordering:')
    ke = KemenyOrder(g,Debug=False)
    #g.showRelationTable()
    print(ke.kemenyRanking)
    print(ke.kemenyOrder)
    print(g.computeOrdinalCorrelation(ke))
    print()
    print('==>> Slater ordering:')
    sl = SlaterOrder(g,Debug=False)
    #g.showRelationTable()
    print(sl.slaterRanking)
    print(sl.slaterOrder)
    corr = g.computeOrdinalCorrelation(sl)
    sl.showCorrelation(corr)
    print()
    print('==>> principal ordering:')
    pri = PrincipalOrder(g)
    #g.showRelationTable()
    print(pri.principalRanking)
    print(pri.principalOrder)
    print(g.computeOrdinalCorrelation(pri))
    print()
    print('==>> Copeland ordering:')
    cop = CopelandOrder(g)
    #g.showRelationTable()
    print(cop.copelandRanking)
    print(cop.copelandOrder)
    print(g.computeOrdinalCorrelation(cop))
    cop.showScores(direction='increasing')
    print()
    print('==>> net flows ordering:')
    nf = NetFlowsOrder(g)
    #g.showRelationTable()
    print(nf.netFlowsRanking)
    print(nf.netFlowsOrder)
    print(g.computeOrdinalCorrelation(nf))
    nf.showScores()
    print()
    print('==>> out flows ordering:')
    of = _OutFlowsOrder(g)
    #g.showRelationTable()
    print(of.outFlowsRanking)
    print(of.outFlowsOrder)
    print(g.computeOrdinalCorrelation(of))
    of.showScores(direction='increasing')
    print()
    print('==>> Kohler ordering:')
    ko = KohlerOrder(g)
    #g.showRelationTable()
    print(ko.kohlerRanking)
    print(ko.kohlerOrder)
    print(g.computeOrdinalCorrelation(ko))
    print()
    print('==>> ranked pairs ordering:')
    rp = RankedPairsOrder(g)
    #g.showRelationTable()
    print(rp.rankedPairsRanking)
    print(rp.rankedPairsOrder)
    print(g.computeOrdinalCorrelation(rp))
    print()
    print('==>> principal ordering:')
    print('Column wise')
    poc = PrincipalOrder(g,Colwise=True,Comments=True)
    print(poc.principalOrder)
    print(g.computeOrderCorrelation(poc.principalOrder))
    print(poc.principalRanking)
    print(g.computeRankingCorrelation(poc.principalRanking))
    print('Row wise')
    por = PrincipalOrder(g,Colwise=False,Comments=True)
    print(por.principalOrder)
    print(g.computeOrderCorrelation(por.principalOrder))
    print(por.principalRanking)
    print(g.computeRankingCorrelation(por.principalRanking))

def testPolarisedBachetRanking():
    print("*==>> testing PolarisedBachetRanking Class ----*")
    from outrankingDigraphs import RandomBipolarOutrankingDigraph
    g = RandomBipolarOutrankingDigraph(numberOfActions=7,seed=1)
    print(g)
    from linearOrders import PolarisedBachetRanking
    actions = [x for x in g.actions]
    ba1 = PolarisedBachetRanking(g,BestQualified=True)
    print(ba1)
    ba1.showScores() 
    print(ba1.correlation)
    ba2 = PolarisedBachetRanking(g,BestQualified=False)
    print(ba2)
    ba2.showScores()
    print(ba2.correlation)
    ba3 = PolarisedBachetRanking(g,randomized=10,seed=1)
    print(ba3)
    ba3.showScores()
    print(ba3.correlation)
    ba4 = PolarisedBachetRanking(g,Optimal=True,Comments=True)
    print(ba4)
    ba4.showScores()
    print(ba4.correlation)

def testValuedBachetRanking():
    print("*==>> testing ValuedBachetRanking Class ----*")
    from outrankingDigraphs import RandomBipolarOutrankingDigraph
    g = RandomBipolarOutrankingDigraph(numberOfActions=7,seed=1)
    print(g)
    from linearOrders import ValuedBachetRanking
    actions = [x for x in g.actions]
    ba1 = ValuedBachetRanking(g,BestQualified=True)
    print(ba1)
    ba1.showScores() 
    print(ba1.correlation)
    ba2 = ValuedBachetRanking(g,BestQualified=False)
    print(ba2)
    ba2.showScores()
    print(ba2.correlation)
    ba3 = ValuedBachetRanking(g,randomized=10,seed=1)
    print(ba3)
    ba3.showScores()
    print(ba3.correlation)
    ba4 = ValuedBachetRanking(g,Optimal=True,Comments=True)
    print(ba4)
    ba4.showScores()
    print(ba4.correlation)

def testSmartBachetRanking():
    print("*==>> testing SmartBachetRanking Class ----*")
    from outrankingDigraphs import RandomBipolarOutrankingDigraph
    g = RandomBipolarOutrankingDigraph(numberOfActions=7,seed=1)
    print(g)
    from linearOrders import BachetRanking
    ba1 = BachetRanking(g,sampleSize=3,Polarised=True)
    print(ba1)
    ba1.showScores() 
    print(ba1.correlation)
    ba2 = BachetRanking(g,Polarised=True,sampleSize=None)
    print(ba2)
    ba2.showScores()
    print(ba2.correlation)
    ba3 = BachetRanking(g,sampleSize=3,Polarised=False)
    print(ba3)
    ba3.showScores(direction='ascending') 
    print(ba3.correlation)
    ba4 = BachetRanking(g,Polarised=False,sampleSize=None)
    print(ba4)
    ba4.showScores()
    print(ba4.correlation)

def testPartialBachetRanking():
    print("*==>> testing SmartBachetRanking Class ----*")
    from outrankingDigraphs import RandomBipolarOutrankingDigraph
    g = RandomBipolarOutrankingDigraph(numberOfActions=9,seed=1)
    print(g)
    from transitiveDigraphs import PartialBachetRanking
    pbr = PartialBachetRanking(g,randomized=10,maxNbrOfRankings=4,seed=3,
                               Polarised=True,Comments=True)
    print(pbr.bachetRankings)
    pbr.showTransitiveDigraph()
    g.computeOrdinalCorrelation(pbr)
    pbr = PartialBachetRanking(g,randomized=100,maxNbrOfRankings=5,seed=3,
                               Polarised=False,Comments=True)
    print(pbr.bachetRankings)
    pbr.showTransitiveDigraph()
    print(g.computeOrdinalCorrelation(pbr))
    g.showBachetChoiceRecommendation()

