# Saved performance Tableau: 
from decimal import Decimal
from collections import OrderedDict
actions = OrderedDict([
('a01', {
'name': 'alternative 1',
'comment': 'Once through',
}),
('a02', {
'name': 'alternative 2',
'comment': 'After cooling tower with natutal air flow',
}),
('a03', {
'name': 'alternative 3',
'comment': 'Half-closed cycle with fixed concentration factor and forced air flow',
}),
('a04', {
'name': 'alternative 4',
'comment': 'Half-closed cycle with fixed concentration factor and hybrid air flow',
}),
('a05', {
'name': 'alternative 5',
'comment': 'Half-closed cycle with fixed concentration factor and natural air flow',
}),
('a06', {
'name': 'alternative 6',
'comment': 'Half-closed cycle with variable concentration factor and natural air flow',
}),
('a07', {
'name': 'alternative 7',
'comment': 'Air condenser with forced air flow',
}),
])
objectives = OrderedDict([
])
criteria = OrderedDict([
('no', {
'name': 'noise',
'comment': 'noise generated by the functioning of the cooling system',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.0'), Decimal('10.00')),
'weight': Decimal('1.0'),
'thresholds': {'ind': (Decimal('0.5'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('vi', {
'name': 'view',
'comment': 'harmonious visual integration in the landscape',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('1.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('im', {
'name': 'im',
'comment': 'image of the site as perceved by the public',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('1.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('hp', {
'name': 'health of personnel',
'comment': 'health risks faced by the workers on the site',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('1.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('hr', {
'name': 'health of residents',
'comment': 'health risks faced by residents living in the neighborhood of the site',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('1.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('sp', {
'name': 'safety of personnel',
'comment': 'risk of accidents at work faced by the personnel',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('1.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('5.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('sr', {
'name': 'safety of residents',
'comment': 'risk of accidents faced by the residents and other persons in the neighborhood of the site',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('100.00')),
'weight': Decimal('1.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('tm', {
'name': 'intake',
'comment': 'intake of matter from the environment which is not entirely restored to the environment in its initial state',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('2.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('cs', {
'name': 'chemical spill',
'comment': 'release of traced of chemicals used for cleaning the system in the environment',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('2.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('hi', {
'name': 'heat input',
'comment': 'impact of the heat release locally',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('2.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('bi', {
'name': 'biological impact',
'comment': 'impact of the local ecosystem',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('2.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
('cost', {
'name': 'total costs',
'comment': 'Investment, running, maintenance and dismantling costs',
'version': 'performance',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('10.00')),
'weight': Decimal('8.0'),
'thresholds': {'ind': (Decimal('0.50'), Decimal('0.00')), 'pref': (Decimal('1.0'), Decimal('0.00')), 'veto': (Decimal('6.00'), Decimal('0.00'))},
}),
])
NA = Decimal('-999')
evaluation = {
'no': {
'a01':Decimal("8.91"),
'a02':Decimal("5.73"),
'a03':Decimal("3.18"),
'a04':Decimal("3.45"),
'a05':Decimal("5.36"),
'a06':Decimal("3.27"),
'a07':Decimal("3.45"),
},
'vi': {
'a01':Decimal("8.18"),
'a02':Decimal("3.36"),
'a03':Decimal("3.91"),
'a04':Decimal("4.27"),
'a05':Decimal("3.36"),
'a06':Decimal("3.82"),
'a07':Decimal("6.09"),
},
'im': {
'a01':Decimal("6.55"),
'a02':Decimal("3.09"),
'a03':Decimal("4.27"),
'a04':Decimal("4.91"),
'a05':Decimal("4.09"),
'a06':Decimal("4.27"),
'a07':Decimal("8.18"),
},
'hp': {
'a01':Decimal("7.36"),
'a02':Decimal("5.09"),
'a03':Decimal("4.18"),
'a04':Decimal("4.55"),
'a05':Decimal("4.82"),
'a06':Decimal("3.91"),
'a07':Decimal("7.91"),
},
'hr': {
'a01':Decimal("7.64"),
'a02':Decimal("6.45"),
'a03':Decimal("5.27"),
'a04':Decimal("5.73"),
'a05':Decimal("6.18"),
'a06':Decimal("5.45"),
'a07':Decimal("8.81"),
},
'sp': {
'a01':Decimal("7.82"),
'a02':Decimal("5.64"),
'a03':Decimal("5.27"),
'a04':Decimal("5.36"),
'a05':Decimal("5.55"),
'a06':Decimal("5.18"),
'a07':Decimal("6.55"),
},
'sr': {
'a01':Decimal("8.00"),
'a02':Decimal("6.45"),
'a03':Decimal("6.55"),
'a04':Decimal("6.45"),
'a05':Decimal("6.45"),
'a06':Decimal("6.55"),
'a07':Decimal("8.00"),
},
'tm': {
'a01':Decimal("2.27"),
'a02':Decimal("2.64"),
'a03':Decimal("4.55"),
'a04':Decimal("5.09"),
'a05':Decimal("4.55"),
'a06':Decimal("4.64"),
'a07':Decimal("9.18"),
},
'cs': {
'a01':Decimal("4.64"),
'a02':Decimal("4.64"),
'a03':Decimal("4.64"),
'a04':Decimal("4.64"),
'a05':Decimal("4.09"),
'a06':Decimal("5.36"),
'a07':Decimal("9.36"),
},
'hi': {
'a01':Decimal("1.82"),
'a02':Decimal("4.09"),
'a03':Decimal("5.27"),
'a04':Decimal("5.18"),
'a05':Decimal("4.91"),
'a06':Decimal("4.64"),
'a07':Decimal("8.55"),
},
'bi': {
'a01':Decimal("2.82"),
'a02':Decimal("4.00"),
'a03':Decimal("4.82"),
'a04':Decimal("5.00"),
'a05':Decimal("4.73"),
'a06':Decimal("4.45"),
'a07':Decimal("9.00"),
},
'cost': {
'a01':Decimal("3.45"),
'a02':Decimal("0.47"),
'a03':Decimal("3.22"),
'a04':Decimal("1.52"),
'a05':Decimal("2.01"),
'a06':Decimal("2.00"),
'a07':Decimal("0.00"),
},
}
