##################
# THE University Rankings 2010
# Author: Times Higher Education
# https://www.timeshighereducation.com/
# MICS ADT May 2020 RB
###################################
from decimal import Decimal
from collections import OrderedDict
actions = OrderedDict([
('DU-UK', {
'name': 'Durham University',
'comment': 'English',
}),
('ENSL-FR', {
'name': 'Ecole Normale Superieure de Lyon',
'comment': 'French',
}),
('ENSP-FR', {
'name': 'Ecole Normale Superieure de Paris',
'comment': 'French',
}),
('EP-FR', {
'name': 'Ecole Polytechnique',
'comment': 'French',
}),
('EPFL-CH', {
'name': 'Ecole Polythechnique Federale de Lausanne',
'comment': 'Swiss',
}),
('ETHZ-CH', {
'name': 'Swiss Federal Institute of Technology Zurich',
'comment': 'Swiss',
}),
('EUT-NL', {
'name': 'Eindhoven University of Technology',
'comment': 'Dutch',
}),
('ICL-UK', {
'name': 'Imperial College London',
'comment': 'English',
}),
('KCL-UK', {
'name': "King's College London",
'comment': 'English',
}),
('KI-S', {
'name': 'Karolinska Institute Sweden',
'comment': 'Swedish',
}),
('KUL-BE', {
'name': 'Catholic University of Leuven, Belgium',
'comment': 'Belgian',
}),
('LSE-UK', {
'name': 'London School of Economics and Political Science',
'comment': 'English',
}),
('LU-S', {
'name': 'Lund University Sweden',
'comment': 'Swedish',
}),
('RHL-UK', {
'name': 'Royal Holloway, University of London',
'comment': 'English',
}),
('RKU-DE', {
'name': 'Ruprecht Karl University of Heidelberg',
'comment': 'German',
}),
('TCD-IR', {
'name': 'Trinity College Dublin',
'comment': 'Irish',
}),
('TUM-DE', {
'name': 'Technical University of Munich',
'comment': 'German',
}),
('UB-CH', {
'name': 'University of Basel',
'comment': 'Swiss',
}),
('UB-UK', {
'name': 'University of Bristol',
'comment': 'English',
}),
('UC-UK', {
'name': 'University of Cambridge',
'comment': 'English',
}),
('UCD-IR', {
'name': 'University College Dublin',
'comment': 'Irish',
}),
('UCL-UK', {
'name': 'University College London',
'comment': 'English',
}),
('UE-UK', {
'name': 'University of Edinburgh',
'comment': 'Scottish',
}),
('UG-CH', {
'name': 'University of Geneva',
'comment': 'Swiss',
}),
('UG-DE', {
'name': 'Univerity of Goettingen',
'comment': 'German',
}),
('UH-FI', {
'name': 'University of Helsinki, Finland',
'comment': 'Finnish',
}),
('UM-DE', {
'name': 'University of Munich',
'comment': 'German',
}),
('UM-UK', {
'name': 'University of Manchester',
'comment': 'English',
}),
('UO-UK', {
'name': 'University of Oxford',
'comment': 'English',
}),
('US-UK', {
'name': 'University of Sussex',
'comment': 'English',
}),
('USTA-UK', {
'name': 'University of St. Andrews',
'comment': 'Scottish',
}),
('USth-UK', {
'name': 'University of Southampton',
'comment': 'English',
}),
('UY-UK', {
'name': 'University of York',
'comment': 'English',
}),
('UZ-CH', {
'name': 'University of Zurich Switzerland',
'comment': 'Swiss',
}),
])
objectives = OrderedDict([
])
criteria = OrderedDict([
('c-Ind', {
'name': 'c-Ind',
'comment': 'performance quantile on industry income',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('100.00')),
'weight': Decimal('1.00'),
'thresholds': {'ind': (Decimal('1.00'), Decimal('0.02')), 'pref': (Decimal('2.50'), Decimal('0.05')), 'veto': (Decimal('50.00'), Decimal('0.00'))},
}),
('c-T', {
'name': 'c-T',
'comment': 'performance quantile on teaching',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('100.00')),
'weight': Decimal('3.00'),
'thresholds': {'ind': (Decimal('1.00'), Decimal('0.02')), 'pref': (Decimal('2.50'), Decimal('0.05')), 'veto': (Decimal('50.00'), Decimal('0.00'))},
}),
('c_C', {
'name': 'c_C',
'comment': 'performance quantile on citations',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('100.00')),
'weight': Decimal('3.00'),
'thresholds': {'ind': (Decimal('1.00'), Decimal('0.02')), 'pref': (Decimal('2.50'), Decimal('0.05')), 'veto': (Decimal('50.00'), Decimal('0.00'))},
}),
('c_I', {
'name': 'c_I',
'comment': 'performance quantile international outlook',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('100.00')),
'weight': Decimal('1.00'),
'thresholds': {'ind': (Decimal('1.00'), Decimal('0.02')), 'pref': (Decimal('2.50'), Decimal('0.05')), 'veto': (Decimal('50.00'), Decimal('0.00'))},
}),
('c_R', {
'name': 'c_R',
'comment': 'performance quantile on research',
'preferenceDirection': 'max',
'scale': (Decimal('0.00'), Decimal('100.00')),
'weight': Decimal('1.00'),
'thresholds': {'ind': (Decimal('1.00'), Decimal('0.02')), 'pref': (Decimal('2.50'), Decimal('0.05')), 'veto': (Decimal('50.00'), Decimal('0.00'))},
}),
])
evaluation = {
'c-Ind': {
'DU-UK':Decimal("33.90"),
'ENSL-FR':Decimal("26.10"),
'ENSP-FR':Decimal("30.70"),
'EP-FR':Decimal("-999.00"),
'EPFL-CH':Decimal("38.00"),
'ETHZ-CH':Decimal("-999.00"),
'EUT-NL':Decimal("99.80"),
'ICL-UK':Decimal("92.90"),
'KCL-UK':Decimal("44.10"),
'KI-S':Decimal("31.70"),
'KUL-BE':Decimal("97.70"),
'LSE-UK':Decimal("38.40"),
'LU-S':Decimal("33.20"),
'RHL-UK':Decimal("30.50"),
'RKU-DE':Decimal("39.10"),
'TCD-IR':Decimal("31.60"),
'TUM-DE':Decimal("-999.00"),
'UB-CH':Decimal("45.80"),
'UB-UK':Decimal("36.20"),
'UC-UK':Decimal("57.00"),
'UCD-IR':Decimal("-999.00"),
'UCL-UK':Decimal("39.00"),
'UE-UK':Decimal("42.20"),
'UG-CH':Decimal("32.70"),
'UG-DE':Decimal("73.30"),
'UH-FI':Decimal("30.20"),
'UM-DE':Decimal("40.40"),
'UM-UK':Decimal("39.00"),
'UO-UK':Decimal("73.50"),
'US-UK':Decimal("29.10"),
'USTA-UK':Decimal("32.60"),
'USth-UK':Decimal("37.70"),
'UY-UK':Decimal("36.20"),
'UZ-CH':Decimal("43.80"),
},
'c-T': {
'DU-UK':Decimal("39.80"),
'ENSL-FR':Decimal("51.10"),
'ENSP-FR':Decimal("66.80"),
'EP-FR':Decimal("57.90"),
'EPFL-CH':Decimal("55.00"),
'ETHZ-CH':Decimal("77.50"),
'EUT-NL':Decimal("55.40"),
'ICL-UK':Decimal("89.20"),
'KCL-UK':Decimal("48.50"),
'KI-S':Decimal("65.80"),
'KUL-BE':Decimal("57.70"),
'LSE-UK':Decimal("62.40"),
'LU-S':Decimal("46.30"),
'RHL-UK':Decimal("37.70"),
'RKU-DE':Decimal("59.20"),
'TCD-IR':Decimal("47.70"),
'TUM-DE':Decimal("50.40"),
'UB-CH':Decimal("42.40"),
'UB-UK':Decimal("49.60"),
'UC-UK':Decimal("88.20"),
'UCD-IR':Decimal("50.80"),
'UCL-UK':Decimal("74.00"),
'UE-UK':Decimal("59.90"),
'UG-CH':Decimal("46.60"),
'UG-DE':Decimal("57.30"),
'UH-FI':Decimal("49.00"),
'UM-DE':Decimal("59.10"),
'UM-UK':Decimal("56.50"),
'UO-UK':Decimal("90.50"),
'US-UK':Decimal("42.40"),
'USTA-UK':Decimal("44.30"),
'USth-UK':Decimal("50.80"),
'UY-UK':Decimal("47.90"),
'UZ-CH':Decimal("56.60"),
},
'c_C': {
'DU-UK':Decimal("91.90"),
'ENSL-FR':Decimal("88.80"),
'ENSP-FR':Decimal("95.70"),
'EP-FR':Decimal("91.40"),
'EPFL-CH':Decimal("83.80"),
'ETHZ-CH':Decimal("83.10"),
'EUT-NL':Decimal("56.90"),
'ICL-UK':Decimal("88.30"),
'KCL-UK':Decimal("72.40"),
'KI-S':Decimal("62.30"),
'KUL-BE':Decimal("45.20"),
'LSE-UK':Decimal("51.60"),
'LU-S':Decimal("67.60"),
'RHL-UK':Decimal("93.20"),
'RKU-DE':Decimal("70.30"),
'TCD-IR':Decimal("84.40"),
'TUM-DE':Decimal("71.20"),
'UB-CH':Decimal("78.30"),
'UB-UK':Decimal("80.90"),
'UC-UK':Decimal("94.00"),
'UCD-IR':Decimal("86.30"),
'UCL-UK':Decimal("80.60"),
'UE-UK':Decimal("86.80"),
'UG-CH':Decimal("63.10"),
'UG-DE':Decimal("92.50"),
'UH-FI':Decimal("75.40"),
'UM-DE':Decimal("76.40"),
'UM-UK':Decimal("59.20"),
'UO-UK':Decimal("95.10"),
'US-UK':Decimal("91.60"),
'USTA-UK':Decimal("72.90"),
'USth-UK':Decimal("72.90"),
'UY-UK':Decimal("81.90"),
'UZ-CH':Decimal("65.00"),
},
'c_I': {
'DU-UK':Decimal("65.70"),
'ENSL-FR':Decimal("37.60"),
'ENSP-FR':Decimal("44.90"),
'EP-FR':Decimal("77.90"),
'EPFL-CH':Decimal("100.00"),
'ETHZ-CH':Decimal("93.70"),
'EUT-NL':Decimal("44.90"),
'ICL-UK':Decimal("90.00"),
'KCL-UK':Decimal("85.90"),
'KI-S':Decimal("-999.00"),
'KUL-BE':Decimal("29.60"),
'LSE-UK':Decimal("99.50"),
'LU-S':Decimal("56.80"),
'RHL-UK':Decimal("92.90"),
'RKU-DE':Decimal("63.40"),
'TCD-IR':Decimal("84.20"),
'TUM-DE':Decimal("85.30"),
'UB-CH':Decimal("91.30"),
'UB-UK':Decimal("67.20"),
'UC-UK':Decimal("77.70"),
'UCD-IR':Decimal("87.00"),
'UCL-UK':Decimal("90.80"),
'UE-UK':Decimal("67.30"),
'UG-CH':Decimal("95.70"),
'UG-DE':Decimal("44.50"),
'UH-FI':Decimal("24.20"),
'UM-DE':Decimal("43.10"),
'UM-UK':Decimal("79.10"),
'UO-UK':Decimal("77.20"),
'US-UK':Decimal("72.80"),
'USTA-UK':Decimal("85.70"),
'USth-UK':Decimal("69.00"),
'UY-UK':Decimal("66.60"),
'UZ-CH':Decimal("87.90"),
},
'c_R': {
'DU-UK':Decimal("44.10"),
'ENSL-FR':Decimal("34.40"),
'ENSP-FR':Decimal("48.20"),
'EP-FR':Decimal("56.10"),
'EPFL-CH':Decimal("56.10"),
'ETHZ-CH':Decimal("87.80"),
'EUT-NL':Decimal("51.70"),
'ICL-UK':Decimal("94.50"),
'KCL-UK':Decimal("54.50"),
'KI-S':Decimal("72.70"),
'KUL-BE':Decimal("62.90"),
'LSE-UK':Decimal("56.20"),
'LU-S':Decimal("60.80"),
'RHL-UK':Decimal("36.20"),
'RKU-DE':Decimal("47.50"),
'TCD-IR':Decimal("45.30"),
'TUM-DE':Decimal("43.20"),
'UB-CH':Decimal("37.10"),
'UB-UK':Decimal("53.10"),
'UC-UK':Decimal("94.10"),
'UCD-IR':Decimal("36.60"),
'UCL-UK':Decimal("81.60"),
'UE-UK':Decimal("61.90"),
'UG-CH':Decimal("49.70"),
'UG-DE':Decimal("55.90"),
'UH-FI':Decimal("51.40"),
'UM-DE':Decimal("57.50"),
'UM-UK':Decimal("56.20"),
'UO-UK':Decimal("93.90"),
'US-UK':Decimal("42.40"),
'USTA-UK':Decimal("47.70"),
'USth-UK':Decimal("47.80"),
'UY-UK':Decimal("46.20"),
'UZ-CH':Decimal("47.00"),
},
}
