################################
# Digraph3 Tutorials
# R. Bisdorff 2020
# Url: https://www.spiegel.de/thema/studentenspiegel/
# Ref: Der Spiegel 48/2004 p.181
#######################################
from decimal import Decimal
from collections import OrderedDict
actions = OrderedDict([
('aach', {
'shortName': 'aach',
'name': 'Aachen, TH',
'comment': 'Higher Technical School',
'rank': 29,
}),
('aug', {
'shortName': 'aug',
'name': 'Augsburg, U',
'comment': 'University',
'rank': 19,
}),
('berf', {
'shortName': 'berf',
'name': 'Berlin, FU',
'comment': 'University',
'rank': 16,
}),
('berh', {
'shortName': 'berh',
'name': 'Berlin Humboldt, U',
'comment': 'University',
'rank': 4,
}),
('bertu', {
'shortName': 'bertu',
'name': 'Berlin, TU',
'comment': 'Technical University',
'rank': 32,
}),
('bie', {
'shortName': 'bie',
'name': 'Bielfeld, U',
'comment': 'University',
'rank': 40,
}),
('boc', {
'shortName': 'boc',
'name': 'Bochum, U',
'comment': 'University',
'rank': 36,
}),
('bon', {
'shortName': 'bon',
'name': 'Bonn, U',
'comment': 'University',
'rank': 16,
}),
('brau', {
'shortName': 'brau',
'name': 'Braunschweig, TU',
'comment': 'Technical University',
'rank': 32,
}),
('brem', {
'shortName': 'brem',
'name': 'Bremen, U',
'comment': 'University',
'rank': 36,
}),
('chem', {
'shortName': 'chem',
'name': 'Chemnitz, TU',
'comment': 'Technical University',
'rank': 23,
}),
('darm', {
'shortName': 'darm',
'name': 'Darmstadt, U',
'comment': 'University',
'rank': 16,
}),
('dres', {
'shortName': 'dres',
'name': 'Dresden, TU',
'comment': 'University',
'rank': 16,
}),
('dsd', {
'shortName': 'dsd',
'name': 'Düsseldorf, U',
'comment': 'University',
'rank': 36,
}),
('duis', {
'shortName': 'duis',
'name': 'Duisburg-Essen, U',
'comment': 'University',
'rank': 41,
}),
('erl', {
'shortName': 'erl',
'name': 'Erlangen-Nürnberg, U',
'comment': 'University',
'rank': 24,
}),
('fran', {
'shortName': 'fran',
'name': 'Frankfurt a. M., U',
'comment': 'University',
'rank': 32,
}),
('frei', {
'shortName': 'frei',
'name': 'Freiburg, U',
'comment': 'University',
'rank': 2,
}),
('gie', {
'shortName': 'gie',
'name': 'Gießen, U',
'comment': 'University',
'rank': 36,
}),
('goet', {
'shortName': 'goet',
'name': 'Göttingen, U',
'comment': 'University',
'rank': 25,
}),
('ham', {
'shortName': 'ham',
'name': 'Hamburg, U',
'comment': 'University',
'rank': 32,
}),
('han', {
'shortName': 'han',
'name': 'Hannover, U',
'comment': 'University',
'rank': 36,
}),
('hei', {
'shortName': 'hei',
'name': 'Heidelberg, U',
'comment': 'University',
'rank': 7,
}),
('jena', {
'shortName': 'jena',
'name': 'Jena, U',
'comment': 'University',
'rank': 14,
}),
('kiel', {
'shortName': 'kiel',
'name': 'Kiel, U',
'comment': 'University',
'rank': 29,
}),
('koel', {
'shortName': 'koel',
'name': 'Köln, U',
'comment': 'University',
'rank': 25,
}),
('kons', {
'shortName': 'kons',
'name': 'Konstanz, U',
'comment': 'University',
'rank': 4,
}),
('ksl', {
'shortName': 'ksl',
'name': 'Kaiserslautern, U',
'comment': 'University',
'rank': 12,
}),
('leip', {
'shortName': 'leip',
'name': 'Leipzig, U',
'comment': 'University',
'rank': 3,
}),
('main', {
'shortName': 'main',
'name': 'Mainz, U',
'comment': 'University',
'rank': 25,
}),
('marb', {
'shortName': 'marb',
'name': 'Marburg, U',
'comment': 'University',
'rank': 16,
}),
('mnh', {
'shortName': 'mnh',
'name': 'Mannhein, U',
'comment': 'University',
'rank': 10,
}),
('mnst', {
'shortName': 'mnst',
'name': 'Münster, U',
'comment': 'University',
'rank': 14,
}),
('mu', {
'shortName': 'mu',
'name': 'München, U',
'comment': 'University',
'rank': 4,
}),
('reg', {
'shortName': 'reg',
'name': 'Regensburg, U',
'comment': 'University',
'rank': 16,
}),
('saar', {
'shortName': 'saar',
'name': 'Saarbrücken, U',
'comment': 'University',
'rank': 16,
}),
('stu', {
'shortName': 'stu',
'name': 'Stuttgart, U',
'comment': 'University',
'rank': 7,
}),
('tri', {
'shortName': 'tri',
'name': 'Trier, U',
'comment': 'University',
'rank': 25,
}),
('tueb', {
'shortName': 'tueb',
'name': 'Tübingen, U',
'comment': 'University',
'rank': 7,
}),
('tum', {
'shortName': 'tum',
'name': 'München TU',
'comment': 'Technical University',
'rank': 1,
}),
('wrzb', {
'shortName': 'wrzb',
'name': 'Würzburg, U',
'comment': 'University',
'rank': 12,
}),
])
objectives = OrderedDict([
    ('HUM', {'name':'Humanities',
             'criteria': ['germ','pol','psy','soc'],
             'weight':4.0}),
    ('LEM', {'name':'Law, Economics & Management',
             'criteria': ['law','eco','mgt'],
             'weight':3.0}),
    ('LSM', {'name':'Life Sciences & Medicine',
             'criteria': ['bio','med'],
             'weight':2.0}),
    ('SCI', {'name':'Natural Sciences & Mathematics',
             'criteria': ['phys','chem','math'],
             'weight':3.0}),  
    ('SCI', {'name':'Technology',
             'criteria': ['info','elec','mec'],
             'weight':3.0}),  
])
criteria = OrderedDict([
('germ', {
'shortName': 'germ',
'name': 'German Studies',
'comment': 'Humanities',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('pol', {
'shortName': 'pol',
'name': 'Politology',
'comment': 'Humanities',
'weight': Decimal('1.0'),
'scale': (50.0, 70.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('psy', {
'shortName': 'psy',
'name': 'Psychology',
'comment': 'Humanities',
'weight': Decimal('1.0'),
'scale': (50.0, 70.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('soc', {
'shortName': 'soc',
'name': 'Sociology',
'comment': 'Humanities',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('law', {
'shortName': 'law',
'name': 'Law Studies',
'comment': 'Law, Economics & Management',
'weight': Decimal('1.0'),
'scale': (35.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('eco', {
'shortName': 'eco',
'name': 'Economics',
'comment': 'Law, Economics & Management',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('mgt', {
'shortName': 'mgt',
'name': 'Management',
'comment': 'Law, Economics & Management',
'weight': Decimal('1.0'),
'scale': (40.0, 80.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('bio', {
'shortName': 'bio',
'name': 'Life Sciences',
'comment': 'Life Sciences & Medicine',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('med', {
'shortName': 'med',
'name': 'Medicine',
'comment': 'Life Sciences & Medicine',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('phys', {
'shortName': 'phys',
'name': 'Physics',
'comment': 'Natural Sciences & Mathematics',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('chem', {
'shortName': 'chem',
'name': 'Chemistry',
'comment': 'Natural Sciences & Mathematics',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('math', {
'shortName': 'math',
'name': 'Mathematics',
'comment': 'Natural Sciences & Mathaematics',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('info', {
'shortName': 'info',
'name': 'Computer Science',
'comment': 'Technology',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('elec', {
'shortName': 'elec',
'name': 'Electrical Engineering',
'comment': 'Technology',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
('mec', {
'shortName': 'mec',
'name': 'Mechanical Engineering',
'comment': 'Technology',
'weight': Decimal('1.0'),
'scale': (45.0, 65.0),
'preferenceDirection': 'max',
'thresholds': {'ind': (Decimal('0.1'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
}),
])
NA = Decimal('-999.00')
evaluation = {
'mgt': {
'aach':Decimal("49.6"),
'aug':Decimal("54.3"),
'berf':Decimal("52.2"),
'berh':Decimal("55.5"),
'bertu':Decimal("54.0"),
'bie':Decimal("50.7"),
'boc':Decimal("-999.00"),
'bon':Decimal("-999.00"),
'brau':Decimal("53.4"),
'brem':Decimal("55.4"),
'chem':Decimal("52.7"),
'darm':Decimal("-999.00"),
'dres':Decimal("54.8"),
'dsd':Decimal("50.5"),
'duis':Decimal("47.5"),
'erl':Decimal("55.6"),
'fran':Decimal("52.0"),
'frei':Decimal("-999.00"),
'gie':Decimal("51.2"),
'goet':Decimal("52.6"),
'ham':Decimal("49.8"),
'han':Decimal("-999.00"),
'hei':Decimal("-999.00"),
'jena':Decimal("56.2"),
'kiel':Decimal("52.8"),
'koel':Decimal("54.6"),
'kons':Decimal("-999.00"),
'ksl':Decimal("55.9"),
'leip':Decimal("54.6"),
'main':Decimal("53.1"),
'marb':Decimal("55.5"),
'mnh':Decimal("59.7"),
'mnst':Decimal("56.3"),
'mu':Decimal("57.5"),
'reg':Decimal("55.5"),
'saar':Decimal("52.2"),
'stu':Decimal("56.6"),
'tri':Decimal("52.8"),
'tueb':Decimal("54.4"),
'tum':Decimal("68.0"),
'wrzb':Decimal("52.8"),
},
'bio': {
'aach':Decimal("52.2"),
'aug':Decimal("-999.00"),
'berf':Decimal("51.6"),
'berh':Decimal("55.0"),
'bertu':Decimal("-999.00"),
'bie':Decimal("49.7"),
'boc':Decimal("48.0"),
'bon':Decimal("50.1"),
'brau':Decimal("53.1"),
'brem':Decimal("53.3"),
'chem':Decimal("-999.00"),
'darm':Decimal("1.00"),
'dres':Decimal("55.3"),
'dsd':Decimal("47.3"),
'duis':Decimal("-999.00"),
'erl':Decimal("51.8"),
'fran':Decimal("51.3"),
'frei':Decimal("55.4"),
'gie':Decimal("50.4"),
'goet':Decimal("50.5"),
'ham':Decimal("52.7"),
'han':Decimal("53.8"),
'hei':Decimal("55.2"),
'jena':Decimal("52.7"),
'kiel':Decimal("52.7"),
'koel':Decimal("51.8"),
'kons':Decimal("55.7"),
'ksl':Decimal("50.8"),
'leip':Decimal("56.9"),
'main':Decimal("50.0"),
'marb':Decimal("53.2"),
'mnh':Decimal("-999.00"),
'mnst':Decimal("51.2"),
'mu':Decimal("50.4"),
'reg':Decimal("54.6"),
'saar':Decimal("-999.00"),
'stu':Decimal("57.1"),
'tri':Decimal("-999.00"),
'tueb':Decimal("53.7"),
'tum':Decimal("53.6"),
'wrzb':Decimal("53.0"),
},
'chem': {
'aach':Decimal("53.6"),
'aug':Decimal("-999.00"),
'berf':Decimal("57.4"),
'berh':Decimal("53.2"),
'bertu':Decimal("52.0"),
'bie':Decimal("54.2"),
'boc':Decimal("53.3"),
'bon':Decimal("53.1"),
'brau':Decimal("50.1"),
'brem':Decimal("-999.00"),
'chem':Decimal("-999.00"),
'darm':Decimal("2.00"),
'dres':Decimal("55.8"),
'dsd':Decimal("53.5"),
'duis':Decimal("52.8"),
'erl':Decimal("54.0"),
'fran':Decimal("55.5"),
'frei':Decimal("57.0"),
'gie':Decimal("-999.00"),
'goet':Decimal("53.9"),
'ham':Decimal("54.2"),
'han':Decimal("53.6"),
'hei':Decimal("56.7"),
'jena':Decimal("57.8"),
'kiel':Decimal("52.8"),
'koel':Decimal("54.0"),
'kons':Decimal("58.0"),
'ksl':Decimal("54.6"),
'leip':Decimal("57.0"),
'main':Decimal("56.3"),
'marb':Decimal("57.8"),
'mnh':Decimal("-999.00"),
'mnst':Decimal("55.0"),
'mu':Decimal("58.1"),
'reg':Decimal("55.8"),
'saar':Decimal("56.2"),
'stu':Decimal("55.2"),
'tri':Decimal("-999.00"),
'tueb':Decimal("57.5"),
'tum':Decimal("58.8"),
'wrzb':Decimal("56.6"),
},
'elec': {
'aach':Decimal("57.2"),
'aug':Decimal("-999.00"),
'berf':Decimal("-999.00"),
'berh':Decimal("-999.00"),
'bertu':Decimal("56.1"),
'bie':Decimal("-999.00"),
'boc':Decimal("54.2"),
'bon':Decimal("-999.00"),
'brau':Decimal("54.5"),
'brem':Decimal("50.1"),
'chem':Decimal("57.5"),
'darm':Decimal("-999.00"),
'dres':Decimal("56.1"),
'dsd':Decimal("-999.00"),
'duis':Decimal("53.6"),
'erl':Decimal("55.9"),
'fran':Decimal("-999.00"),
'frei':Decimal("-999.00"),
'gie':Decimal("-999.00"),
'goet':Decimal("-999.00"),
'ham':Decimal("-999.00"),
'han':Decimal("53.5"),
'hei':Decimal("-999.00"),
'jena':Decimal("-999.00"),
'kiel':Decimal("54.2"),
'koel':Decimal("-999.00"),
'kons':Decimal("-999.00"),
'ksl':Decimal("57.5"),
'leip':Decimal("-999.00"),
'main':Decimal("-999.00"),
'marb':Decimal("-999.00"),
'mnh':Decimal("-999.00"),
'mnst':Decimal("-999.00"),
'mu':Decimal("-999.00"),
'reg':Decimal("-999.00"),
'saar':Decimal("-999.00"),
'stu':Decimal("60.2"),
'tri':Decimal("-999.00"),
'tueb':Decimal("-999.00"),
'tum':Decimal("58.2"),
'wrzb':Decimal("-999.00"),
},
'germ': {
'aach':Decimal("53.3"),
'aug':Decimal("57.9"),
'berf':Decimal("54.7"),
'berh':Decimal("57.3"),
'bertu':Decimal("51.4"),
'bie':Decimal("51.4"),
'boc':Decimal("53.9"),
'bon':Decimal("54.1"),
'brau':Decimal("53.5"),
'brem':Decimal("56.9"),
'chem':Decimal("54.3"),
'darm':Decimal("1.00"),
'dres':Decimal("55.2"),
'dsd':Decimal("53.5"),
'duis':Decimal("50.6"),
'erl':Decimal("57.9"),
'fran':Decimal("51.7"),
'frei':Decimal("57.8"),
'gie':Decimal("53.0"),
'goet':Decimal("58.7"),
'ham':Decimal("57.0"),
'han':Decimal("50.4"),
'hei':Decimal("61.4"),
'jena':Decimal("56.5"),
'kiel':Decimal("51.9"),
'koel':Decimal("51.7"),
'kons':Decimal("56.9"),
'ksl':Decimal("-999.00"),
'leip':Decimal("57.4"),
'main':Decimal("54.2"),
'marb':Decimal("53.6"),
'mnh':Decimal("52.2"),
'mnst':Decimal("55.4"),
'mu':Decimal("57.2"),
'reg':Decimal("54.8"),
'saar':Decimal("57.9"),
'stu':Decimal("52.5"),
'tri':Decimal("54.1"),
'tueb':Decimal("57.9"),
'tum':Decimal("-999.00"),
'wrzb':Decimal("56.9"),
},
'info': {
'aach':Decimal("54.6"),
'aug':Decimal("58.1"),
'berf':Decimal("54.9"),
'berh':Decimal("55.8"),
'bertu':Decimal("55.4"),
'bie':Decimal("55.8"),
'boc':Decimal("-999.00"),
'bon':Decimal("53.7"),
'brau':Decimal("52.6"),
'brem':Decimal("54.1"),
'chem':Decimal("57.7"),
'darm':Decimal("3.00"),
'dres':Decimal("56.2"),
'dsd':Decimal("-999.00"),
'duis':Decimal("56.8"),
'erl':Decimal("54.6"),
'fran':Decimal("52.4"),
'frei':Decimal("58.1"),
'gie':Decimal("-999.00"),
'goet':Decimal("-999.00"),
'ham':Decimal("54.7"),
'han':Decimal("58.8"),
'hei':Decimal("-999.00"),
'jena':Decimal("57.2"),
'kiel':Decimal("54.9"),
'koel':Decimal("-999.00"),
'kons':Decimal("59.7"),
'ksl':Decimal("56.2"),
'leip':Decimal("3.00"),
'main':Decimal("-999.00"),
'marb':Decimal("55.6"),
'mnh':Decimal("58.6"),
'mnst':Decimal("57.7"),
'mu':Decimal("57.1"),
'reg':Decimal("-999.00"),
'saar':Decimal("57.6"),
'stu':Decimal("59.8"),
'tri':Decimal("52.3"),
'tueb':Decimal("55.2"),
'tum':Decimal("58.2"),
'wrzb':Decimal("55.9"),
},
'law': {
'aach':Decimal("-999.00"),
'aug':Decimal("45.6"),
'berf':Decimal("45.7"),
'berh':Decimal("48.8"),
'bertu':Decimal("-999.00"),
'bie':Decimal("41.9"),
'boc':Decimal("39.1"),
'bon':Decimal("47.2"),
'brau':Decimal("-999.00"),
'brem':Decimal("40.9"),
'chem':Decimal("-999.00"),
'darm':Decimal("-999.00"),
'dres':Decimal("44.0"),
'dsd':Decimal("44.9"),
'duis':Decimal("-999.00"),
'erl':Decimal("42.9"),
'fran':Decimal("41.9"),
'frei':Decimal("50.7"),
'gie':Decimal("41.9"),
'goet':Decimal("44.8"),
'ham':Decimal("44.1"),
'han':Decimal("41.2"),
'hei':Decimal("51.1"),
'jena':Decimal("45.3"),
'kiel':Decimal("45.1"),
'koel':Decimal("46.1"),
'kons':Decimal("48.3"),
'ksl':Decimal("-999.00"),
'leip':Decimal("46.3"),
'main':Decimal("46.5"),
'marb':Decimal("40.3"),
'mnh':Decimal("45.0"),
'mnst':Decimal("46.4"),
'mu':Decimal("47.3"),
'reg':Decimal("46.1"),
'saar':Decimal("48.1"),
'stu':Decimal("-999.00"),
'tri':Decimal("46.3"),
'tueb':Decimal("46.8"),
'tum':Decimal("-999.00"),
'wrzb':Decimal("46.4"),
},
'mec': {
'aach':Decimal("54.4"),
'aug':Decimal("-999.00"),
'berf':Decimal("-999.00"),
'berh':Decimal("-999.00"),
'bertu':Decimal("54.3"),
'bie':Decimal("-999.00"),
'boc':Decimal("54.4"),
'bon':Decimal("-999.00"),
'brau':Decimal("55.2"),
'brem':Decimal("-999.00"),
'chem':Decimal("53.6"),
'darm':Decimal("56.1"),
'dres':Decimal("54.8"),
'dsd':Decimal("-999.00"),
'duis':Decimal("51.9"),
'erl':Decimal("55.1"),
'fran':Decimal("-999.00"),
'frei':Decimal("-999.00"),
'gie':Decimal("-999.00"),
'goet':Decimal("-999.00"),
'ham':Decimal("-999.00"),
'han':Decimal("53.6"),
'hei':Decimal("-999.00"),
'jena':Decimal("-999.00"),
'kiel':Decimal("-999.00"),
'koel':Decimal("-999.00"),
'kons':Decimal("-999.00"),
'ksl':Decimal("56.3"),
'leip':Decimal("-999.00"),
'main':Decimal("-999.00"),
'marb':Decimal("-999.00"),
'mnh':Decimal("-999.00"),
'mnst':Decimal("-999.00"),
'mu':Decimal("-999.00"),
'reg':Decimal("-999.00"),
'saar':Decimal("-999.00"),
'stu':Decimal("57.8"),
'tri':Decimal("-999.00"),
'tueb':Decimal("-999.00"),
'tum':Decimal("56.9"),
'wrzb':Decimal("-999.00"),
},
'math': {
'aach':Decimal("58.6"),
'aug':Decimal("61.2"),
'berf':Decimal("-999.00"),
'berh':Decimal("57.9"),
'bertu':Decimal("56.8"),
'bie':Decimal("56.3"),
'boc':Decimal("57.6"),
'bon':Decimal("59.4"),
'brau':Decimal("54.7"),
'brem':Decimal("-999.00"),
'chem':Decimal("-999.00"),
'darm':Decimal("59.4"),
'dres':Decimal("57.8"),
'dsd':Decimal("-999.00"),
'duis':Decimal("51.6"),
'erl':Decimal("60.5"),
'fran':Decimal("57.0"),
'frei':Decimal("60.6"),
'gie':Decimal("-999.00"),
'goet':Decimal("63.1"),
'ham':Decimal("54.9"),
'han':Decimal("56.6"),
'hei':Decimal("61.3"),
'jena':Decimal("-999.00"),
'kiel':Decimal("-999.00"),
'koel':Decimal("56.5"),
'kons':Decimal("-999.00"),
'ksl':Decimal("62.2"),
'leip':Decimal("-999.00"),
'main':Decimal("54.7"),
'marb':Decimal("-999.00"),
'mnh':Decimal("-999.00"),
'mnst':Decimal("56.9"),
'mu':Decimal("59.6"),
'reg':Decimal("59.2"),
'saar':Decimal("-999.00"),
'stu':Decimal("60.6"),
'tri':Decimal("60.7"),
'tueb':Decimal("-999.00"),
'tum':Decimal("62.6"),
'wrzb':Decimal("-999.00"),
},
'med': {
'aach':Decimal("49.5"),
'aug':Decimal("-999.00"),
'berf':Decimal("49.0"),
'berh':Decimal("52.3"),
'bertu':Decimal("-999.00"),
'bie':Decimal("-999.00"),
'boc':Decimal("49.8"),
'bon':Decimal("3.00"),
'brau':Decimal("-999.00"),
'brem':Decimal("-999.00"),
'chem':Decimal("-999.00"),
'darm':Decimal("-999.00"),
'dres':Decimal("49.2"),
'dsd':Decimal("50.5"),
'duis':Decimal("48.0"),
'erl':Decimal("49.3"),
'fran':Decimal("51.2"),
'frei':Decimal("54.2"),
'gie':Decimal("50.0"),
'goet':Decimal("48.9"),
'ham':Decimal("49.2"),
'han':Decimal("-999.00"),
'hei':Decimal("55.5"),
'jena':Decimal("51.1"),
'kiel':Decimal("49.6"),
'koel':Decimal("50.7"),
'kons':Decimal("-999.00"),
'ksl':Decimal("-999.00"),
'leip':Decimal("51.5"),
'main':Decimal("49.2"),
'marb':Decimal("51.1"),
'mnh':Decimal("-999.00"),
'mnst':Decimal("52.8"),
'mu':Decimal("52.6"),
'reg':Decimal("50.9"),
'saar':Decimal("49.6"),
'stu':Decimal("-999.00"),
'tri':Decimal("-999.00"),
'tueb':Decimal("52.1"),
'tum':Decimal("60.1"),
'wrzb':Decimal("52.2"),
},
'phys': {
'aach':Decimal("59.1"),
'aug':Decimal("62.3"),
'berf':Decimal("61.6"),
'berh':Decimal("61.9"),
'bertu':Decimal("58.9"),
'bie':Decimal("53.9"),
'boc':Decimal("56.8"),
'bon':Decimal("59.9"),
'brau':Decimal("59.8"),
'brem':Decimal("59.7"),
'chem':Decimal("-999.00"),
'darm':Decimal("62.5"),
'dres':Decimal("59.9"),
'dsd':Decimal("-999.00"),
'duis':Decimal("54.6"),
'erl':Decimal("60.3"),
'fran':Decimal("62.1"),
'frei':Decimal("61.6"),
'gie':Decimal("57.6"),
'goet':Decimal("60.4"),
'ham':Decimal("56.4"),
'han':Decimal("57.5"),
'hei':Decimal("60.9"),
'jena':Decimal("61.6"),
'kiel':Decimal("59.7"),
'koel':Decimal("58.7"),
'kons':Decimal("59.9"),
'ksl':Decimal("59.7"),
'leip':Decimal("62.2"),
'main':Decimal("60.8"),
'marb':Decimal("62.8"),
'mnh':Decimal("-999.00"),
'mnst':Decimal("55.2"),
'mu':Decimal("62.0"),
'reg':Decimal("60.5"),
'saar':Decimal("61.2"),
'stu':Decimal("61.5"),
'tri':Decimal("-999.00"),
'tueb':Decimal("61.6"),
'tum':Decimal("62.8"),
'wrzb':Decimal("60.2"),
},
'pol': {
'aach':Decimal("50.8"),
'aug':Decimal("54.3"),
'berf':Decimal("61.4"),
'berh':Decimal("58.5"),
'bertu':Decimal("-999.00"),
'bie':Decimal("-999.00"),
'boc':Decimal("-999.00"),
'bon':Decimal("57.3"),
'brau':Decimal("54.0"),
'brem':Decimal("55.5"),
'chem':Decimal("57.1"),
'darm':Decimal("59.7"),
'dres':Decimal("55.9"),
'dsd':Decimal("-999.00"),
'duis':Decimal("52.5"),
'erl':Decimal("55.1"),
'fran':Decimal("53.1"),
'frei':Decimal("60.5"),
'gie':Decimal("59.0"),
'goet':Decimal("56.3"),
'ham':Decimal("60.2"),
'han':Decimal("52.8"),
'hei':Decimal("59.5"),
'jena':Decimal("55.8"),
'kiel':Decimal("52.2"),
'koel':Decimal("57.6"),
'kons':Decimal("65.9"),
'ksl':Decimal("-999.00"),
'leip':Decimal("60.4"),
'main':Decimal("57.9"),
'marb':Decimal("54.7"),
'mnh':Decimal("57.2"),
'mnst':Decimal("56.7"),
'mu':Decimal("60.1"),
'reg':Decimal("55.4"),
'saar':Decimal("-999.00"),
'stu':Decimal("58.4"),
'tri':Decimal("58.0"),
'tueb':Decimal("57.7"),
'tum':Decimal("-999.00"),
'wrzb':Decimal("56.0"),
},
'psy': {
'aach':Decimal("62.7"),
'aug':Decimal("-999.00"),
'berf':Decimal("59.8"),
'berh':Decimal("59.8"),
'bertu':Decimal("57.7"),
'bie':Decimal("54.4"),
'boc':Decimal("55.2"),
'bon':Decimal("60.3"),
'brau':Decimal("-999.00"),
'brem':Decimal("52.5"),
'chem':Decimal("60.8"),
'darm':Decimal("58.6"),
'dres':Decimal("60.6"),
'dsd':Decimal("57.5"),
'duis':Decimal("-999.00"),
'erl':Decimal("58.7"),
'fran':Decimal("58.0"),
'frei':Decimal("64.1"),
'gie':Decimal("58.0"),
'goet':Decimal("59.8"),
'ham':Decimal("57.3"),
'han':Decimal("-999.00"),
'hei':Decimal("59.8"),
'jena':Decimal("58.5"),
'kiel':Decimal("58.4"),
'koel':Decimal("58.9"),
'kons':Decimal("59.1"),
'ksl':Decimal("-999.00"),
'leip':Decimal("62.4"),
'main':Decimal("56.9"),
'marb':Decimal("57.6"),
'mnh':Decimal("61.1"),
'mnst':Decimal("62.2"),
'mu':Decimal("60.9"),
'reg':Decimal("62.1"),
'saar':Decimal("56.5"),
'stu':Decimal("-999.00"),
'tri':Decimal("58.3"),
'tueb':Decimal("58.4"),
'tum':Decimal("-999.00"),
'wrzb':Decimal("59.8"),
},
'soc': {
'aach':Decimal("51.0"),
'aug':Decimal("54.8"),
'berf':Decimal("55.5"),
'berh':Decimal("59.2"),
'bertu':Decimal("59.1"),
'bie':Decimal("55.6"),
'boc':Decimal("-999.00"),
'bon':Decimal("56.0"),
'brau':Decimal("51.5"),
'brem':Decimal("54.5"),
'chem':Decimal("53.3"),
'darm':Decimal("52.0"),
'dres':Decimal("56.2"),
'dsd':Decimal("48.8"),
'duis':Decimal("47.9"),
'erl':Decimal("55.4"),
'fran':Decimal("51.5"),
'frei':Decimal("57.5"),
'gie':Decimal("-999.00"),
'goet':Decimal("53.5"),
'ham':Decimal("53.6"),
'han':Decimal("49.9"),
'hei':Decimal("52.2"),
'jena':Decimal("52.8"),
'kiel':Decimal("-999.00"),
'koel':Decimal("56.1"),
'kons':Decimal("54.7"),
'ksl':Decimal("-999.00"),
'leip':Decimal("59.5"),
'main':Decimal("55.7"),
'marb':Decimal("59.8"),
'mnh':Decimal("55.0"),
'mnst':Decimal("56.3"),
'mu':Decimal("54.0"),
'reg':Decimal("-999.00"),
'saar':Decimal("-999.00"),
'stu':Decimal("-999.00"),
'tri':Decimal("54.9"),
'tueb':Decimal("1.00"),
'tum':Decimal("-999.00"),
'wrzb':Decimal("-999.00"),
},
'eco': {
'aach':Decimal("-999.00"),
'aug':Decimal("-999.00"),
'berf':Decimal("50.5"),
'berh':Decimal("59.5"),
'bertu':Decimal("49.6"),
'bie':Decimal("-999.00"),
'boc':Decimal("-999.00"),
'bon':Decimal("53.6"),
'brau':Decimal("-999.00"),
'brem':Decimal("-999.00"),
'chem':Decimal("-999.00"),
'darm':Decimal("-999.00"),
'dres':Decimal("56.7"),
'dsd':Decimal("-999.00"),
'duis':Decimal("-999.00"),
'erl':Decimal("-999.00"),
'fran':Decimal("53.5"),
'frei':Decimal("53.3"),
'gie':Decimal("-999.00"),
'goet':Decimal("53.6"),
'ham':Decimal("52.1"),
'han':Decimal("-999.00"),
'hei':Decimal("54.4"),
'jena':Decimal("-999.00"),
'kiel':Decimal("50.5"),
'koel':Decimal("56.1"),
'kons':Decimal("59.0"),
'ksl':Decimal("-999.00"),
'leip':Decimal("-999.00"),
'main':Decimal("50.7"),
'marb':Decimal("-999.00"),
'mnh':Decimal("57.0"),
'mnst':Decimal("54.1"),
'mu':Decimal("55.8"),
'reg':Decimal("52.3"),
'saar':Decimal("-999.00"),
'stu':Decimal("-999.00"),
'tri':Decimal("52.8"),
'tueb':Decimal("60.8"),
'tum':Decimal("-999.00"),
'wrzb':Decimal("53.3"),
},
}
