# Saved performance Tableau: 
from decimal import Decimal
from collections import OrderedDict
actions = OrderedDict([
('A', {
'comment': 'High standing city centre',
'name': 'Avenue de la Liberté',
'shortName': 'Ave',
}),
('B', {
'comment': 'Industrial environment',
'name': 'Bonnevoie',
'shortName': 'Bon',
}),
('C', {
'comment': 'Industrial suburb location',
'name': 'Cessange',
'shortName': 'Ces',
}),
('D', {
'comment': 'Industrial suburb environment',
'name': 'Dommeldange',
'shortName': 'Dom',
}),
('E', {
'comment': 'New and ambitious urbanization far from the city',
'name': 'Esch-Belval',
'shortName': 'Bel',
}),
('F', {
'comment': 'Out in the countryside',
'name': 'Fentange',
'shortName': 'Fen',
}),
('G', {
'comment': 'Main town shopping aera',
'name': 'Avenue de la Gare',
'shortName': 'Gar',
}),
])
objectives = OrderedDict([
('Cts', {'weight': Decimal('45'), 'criteria': ['C'], 'name': 'Total Costs', 'comment': 'minimize the yearly costs induced by the moving'}), 
('Tov', {'weight': Decimal('81'), 'criteria': ['Pr', 'St', 'V'], 'name': 'Business Turnover', 'comment': 'maximise the future turnover'}), 
('Wrk', {'weight': Decimal('19'), 'criteria': ['Cf', 'P', 'W'], 'name': 'Working Conditions', 'comment': 'maximize the new working conditions'})
])
criteria = OrderedDict([
('C', {
'comment': 'Annual rent, charges and cleaning',
'weight': Decimal('45.00'),
'scale': (Decimal('0.00'), Decimal('50000.00')),
'preferenceDirection': 'min',
'name': 'Costs',
'thresholds': {'ind': (Decimal('1000.00'), Decimal('0.00')), 'veto': (Decimal('35000.00'), Decimal('0.00')), 'pref': (Decimal('2500.00'), Decimal('0.00'))},
'version': 'performance',
'objective': 'Cts',
}),
('Cf', {
'comment': 'Quality of the office equipments',
'weight': Decimal('6.00'),
'scale': (Decimal('0.00'), Decimal('100.00')),
'preferenceDirection': 'max',
'name': 'Comfort',
'thresholds': {'ind': (Decimal('10.00'), Decimal('0.00')), 'veto': (Decimal('80.00'), Decimal('0.00')), 'pref': (Decimal('20.00'), Decimal('0.00'))},
'version': 'performance',
'objective': 'Wrk',
}),
('P', {
'comment': 'Available parking facilities',
'weight': Decimal('3.00'),
'scale': (Decimal('0.00'), Decimal('100.00')),
'preferenceDirection': 'max',
'name': 'Parking',
'thresholds': {'ind': (Decimal('10.00'), Decimal('0.00')), 'veto': (Decimal('80.00'), Decimal('0.00')), 'pref': (Decimal('20.00'), Decimal('0.00'))},
'version': 'performance',
'objective': 'Wrk',
}),
('Pr', {
'comment': 'Distance from a town center',
'weight': Decimal('32.00'),
'scale': (Decimal('0.00'), Decimal('100.00')),
'preferenceDirection': 'max',
'name': 'Proximity',
'thresholds': {'ind': (Decimal('10.00'), Decimal('0.00')), 'veto': (Decimal('80.00'), Decimal('0.00')), 'pref': (Decimal('20.00'), Decimal('0.00'))},
'version': 'performance',
'objective': 'Tov',
}),
('St', {
'comment': 'Standing, image et presentation of the site',
'weight': Decimal('23.00'),
'scale': (Decimal('0.00'), Decimal('100.00')),
'preferenceDirection': 'max',
'name': 'Standing',
'thresholds': {'ind': (Decimal('10.00'), Decimal('0.00')), 'veto': (Decimal('80.00'), Decimal('0.00')), 'pref': (Decimal('20.00'), Decimal('0.00'))},
'version': 'performance',
'objective': 'Tov',
}),
('V', {
'comment': 'Circulation of potential customers',
'weight': Decimal('26.00'),
'scale': (Decimal('0.00'), Decimal('100.00')),
'preferenceDirection': 'max',
'name': 'Visibility',
'thresholds': {'ind': (Decimal('10.00'), Decimal('0.00')), 'veto': (Decimal('80.00'), Decimal('0.00')), 'pref': (Decimal('20.00'), Decimal('0.00'))},
'version': 'performance',
'objective': 'Tov',
}),
('W', {
'comment': 'Measured in in square meters',
'weight': Decimal('10.00'),
'scale': (Decimal('0.00'), Decimal('100.00')),
'preferenceDirection': 'max',
'name': 'Working space',
'thresholds': {'ind': (Decimal('10.00'), Decimal('0.00')), 'veto': (Decimal('80.00'), Decimal('0.00')), 'pref': (Decimal('20.00'), Decimal('0.00'))},
'version': 'performance',
'objective': 'Wrk',
}),
])
evaluation = {
'C': {
'A':Decimal("-35000.00"),
'B':Decimal("-17800.00"),
'C':Decimal("-6700.00"),
'D':Decimal("-14100.00"),
'E':Decimal("-34800.00"),
'F':Decimal("-18600.00"),
'G':Decimal("-12000.00"),
},
'Cf': {
'A':Decimal("0.00"),
'B':Decimal("100.00"),
'C':Decimal("10.00"),
'D':Decimal("30.00"),
'E':Decimal("60.00"),
'F':Decimal("80.00"),
'G':Decimal("50.00"),
},
'P': {
'A':Decimal("90.00"),
'B':Decimal("30.00"),
'C':Decimal("100.00"),
'D':Decimal("90.00"),
'E':Decimal("70.00"),
'F':Decimal("0.00"),
'G':Decimal("80.00"),
},
'Pr': {
'A':Decimal("100.00"),
'B':Decimal("20.00"),
'C':Decimal("80.00"),
'D':Decimal("70.00"),
'E':Decimal("40.00"),
'F':Decimal("0.00"),
'G':Decimal("60.00"),
},
'St': {
'A':Decimal("100.00"),
'B':Decimal("10.00"),
'C':Decimal("0.00"),
'D':Decimal("30.00"),
'E':Decimal("90.00"),
'F':Decimal("70.00"),
'G':Decimal("20.00"),
},
'V': {
'A':Decimal("60.00"),
'B':Decimal("80.00"),
'C':Decimal("70.00"),
'D':Decimal("50.00"),
'E':Decimal("60.00"),
'F':Decimal("0.00"),
'G':Decimal("100.00"),
},
'W': {
'A':Decimal("75.00"),
'B':Decimal("30.00"),
'C':Decimal("0.00"),
'D':Decimal("55.00"),
'E':Decimal("100.00"),
'F':Decimal("0.00"),
'G':Decimal("50.00"),
},
}
