###################################
# Digraph3 documentation
# Alice's best choice: Case study
# (C) R. Bisdorff Nov 2020
# Digraph3/examples/AliceChoice.py
##################################3
from decimal import Decimal
from collections import OrderedDict
actions = OrderedDict([
('T-UD', {
'shortName': 'T-UD',
'name': 'Qualified translator, University Düsseldorf',
'comment': 'fees: 400€, study length: 4.5 years',
}),
('T-FHK', {
'shortName': 'T-FHK',
'name': 'Qualified translator, Higher Technical School Köln',
'comment': 'fees: 400€, study length: 4 years',
}),
('T-FHM', {
'shortName': 'T-FHM',
'name': 'Qualified translator, Higher Technical School München',
'comment': 'fees: 400€, study length: 4 years',
}),
('I-FHK', {
'shortName': 'I-FHK',
'name': 'Graduate interpreter, Higher Technical School Köln',
'comment': 'fees: 400€, study length: 4 years',
}),
('T-USB', {
'shortName': 'T-USB',
'name': 'Qualified translator, University Saarbrücken',
'comment': 'fees: 400€, study length: 4.5 years',
}),
('I-USB', {
'shortName': 'I-USB',
'name': 'Graduate interpreter, University Saarbrücken',
'comment': 'fees: 400€, study length: 4.5 years',
}),
('T-UHB', {
'shortName': 'T-UHB',
'name': 'Qualified translator, University Heidelberg',
'comment': 'fees: 400€, study length: 4.5 years',
}),
('I-UHB', {
'shortName': 'I-UHB',
'name': 'Graduate interpreter, University Heidelberg',
'comment': 'fees: 400€, study length: 4.5 years',
}),
('S-HKK', {
'shortName': 'S-HKK',
'name': 'Specialized secretary, Chamber of Commerce, Köln',
'comment': 'fees: 4000€, study length: 2 years',
}),
('C-HKK', {
'shortName': 'C-HKK',
'name': 'Foreign correspondent, Chamber of Commerce, Köln',
'comment': 'fees: 4000€, study length: 2 years',
}),
])
objectives = OrderedDict([
('GEO', {
'name': 'Geographical aspect',
'comment': "Proximity to parent's home and big city",
'criteria': ['DH', 'BC'],
'weight': Decimal('6'),
}),
('LEA', {
'name': 'Learning aspect',
'comment': 'Quality of the study program',
'criteria': ['AS'],
'weight': Decimal('6'),
}),
('FIN', {
'name': 'Financial aspect',
'comment': 'fees, living costs and study time',
'criteria': ['SF', 'LC','SL'],
'weight': Decimal('6'),
}),
('PRA', {
'name': 'Professional aspect',
'comment': 'Attractiveness, prestige and income of the profession',
'criteria': ['AP', 'AI', 'OP'],
'weight': Decimal('6'),
}),
])
criteria = OrderedDict([
('DH', {
'objective': 'GEO',
'preferenceDirection': 'min',
'name': "Distance to parent's home",
'shortName': 'DH',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.0')), 'pref': (Decimal('10.0'), Decimal('0.0'))},
'scale': (0.0, 1000.0),
'weight': 3,
'comment': 'Geographical aspect measured in km',
}),
('BC', {
'objective': 'GEO',
'preferenceDirection': 'max',
'name': 'Number of inhabitants',
'shortName': 'BC',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.01')), 'pref': (Decimal('0.0'), Decimal('0.05'))},
'scale': (0.0, 2000.0),
'weight': 3,
'comment': 'Geographical aspect: measured in x / 1000',
}),
('AS', {
'objective': 'LEA',
'preferenceDirection': 'max',
'name': 'Attractiveness of the study program',
'shortName': 'AS',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.0')), 'pref': (Decimal('1.0'), Decimal('0.0')), 'veto': (Decimal('7.0'), Decimal('0.0'))},
'scale': (0.0, 10.0),
'weight': 6,
'comment': 'Learning aspect subjectively measured from 0 (weak) to 10 (excellent)',
}),
('SF', {
'objective': 'FIN',
'preferenceDirection': 'min',
'name': 'Annual registration fees',
'shortName': 'SF',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.0')), 'pref': (Decimal('100.00'), Decimal('0.0'))},
'scale': (400.0, 4000.0),
'weight': 2,
'comment': 'Financial aspect measured in Euros',
}),
('SL', {
'objective': 'FIN',
'preferenceDirection': 'min',
'name': 'Study time',
'shortName': 'SL',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.0')), 'pref': (Decimal('0.5'), Decimal('0.0'))},
'scale': (0.0, 10.0),
'weight': 2,
'comment': 'Financial aspect measured in number of semesters',
}),
('LC', {
'objective': 'FIN',
'preferenceDirection': 'min',
'name': 'Monthly living costs',
'shortName': 'LC',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.0')), 'pref': (Decimal('100.0'), Decimal('0.0'))},
'scale': (0.0, 1000.0),
'weight': 2,
'comment': 'Financial aspect measured in Euros',
}),
('AI', {
'objective': 'PRA',
'preferenceDirection': 'max',
'name': 'Annual professional income after studying',
'shortName': 'AI',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.0')), 'pref': (Decimal('1.00'), Decimal('0.0'))},
'scale': (0.0, 50.0),
'weight': 2,
'comment': 'Professional aspect measured in  x / 1000 Euros',
}),
('AP', {
'objective': 'PRA',
'preferenceDirection': 'max',
'name': 'Attractiveness of the profession',
'shortName': 'AP',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.0')), 'pref': (Decimal('1.0'), Decimal('0.0'))},
'scale': (0.0, 2.0),
'weight': 2,
'comment': 'Professional aspect subjectively measured on a three-level scale: 0 (weak), 1 (fair), 2 (good)',
}),
('OP', {
'objective': 'PRA',
'preferenceDirection': 'max',
'name': 'Occupational Prestige',
'shortName': 'OP',
'thresholds': {'ind': (Decimal('0.0'), Decimal('0.0')), 'pref': (Decimal('10.0'), Decimal('0.0'))},
'scale': (0.0, 100.0),
'weight': 2,
'comment': 'Professional aspect measured in SIOPS points',
}),
])
evaluation = {
'DH': {
'T-UD':Decimal("-41"),
'T-FHK':Decimal("0"),
'T-FHM':Decimal("-631"),
'I-FHK':Decimal('0'),
'T-USB':Decimal("-260"),
'I-USB':Decimal("-269"),
'T-UHB':Decimal("-275"),
'I-UHB':Decimal("-275"),
'S-HKK':Decimal("0"),
'C-HKK':Decimal("0"),
},
'BC': {
'T-UD':Decimal("567"),
'T-FHK':Decimal("1015"),
'T-FHM':Decimal("1241"),
'I-FHK':Decimal('1015'),
'T-USB':Decimal("196"),
'I-USB':Decimal("196"),
'T-UHB':Decimal("140"),
'I-UHB':Decimal("140"),
'S-HKK':Decimal("1015"),
'C-HKK':Decimal("1015"),
},
'AS': {
'T-UD':Decimal("5"),
'T-FHK':Decimal("5"),
'T-FHM':Decimal("4"),
'I-FHK':Decimal('8'),
'T-USB':Decimal("5"),
'I-USB':Decimal("8"),
'T-UHB':Decimal("5"),
'I-UHB':Decimal("8"),
'S-HKK':Decimal("1"),
'C-HKK':Decimal("2"),
},
'SF': {
'T-UD':Decimal("-400"),
'T-FHK':Decimal("-400"),
'T-FHM':Decimal("-400"),
'I-FHK':Decimal('-400'),
'T-USB':Decimal("-400"),
'I-USB':Decimal("-400"),
'T-UHB':Decimal("-400"),
'I-UHB':Decimal("-400"),
'S-HKK':Decimal("-4000"),
'C-HKK':Decimal("-4000"),
},
'SL': {
'T-UD':Decimal("-9"),
'T-FHK':Decimal("-8"),
'T-FHM':Decimal("-8"),
'I-FHK':Decimal('-8'),
'T-USB':Decimal("-9"),
'I-USB':Decimal("-9"),
'T-UHB':Decimal("-9"),
'I-UHB':Decimal("-9"),
'S-HKK':Decimal("-4"),
'C-HKK':Decimal("-4"),
},
'LC': {
'T-UD':Decimal("-1000"),
'T-FHK':Decimal("0"),
'T-FHM':Decimal("-1000"),
'I-FHK':Decimal('0'),
'T-USB':Decimal("-1000"),
'I-USB':Decimal("-1000"),
'T-UHB':Decimal("-1000"),
'I-UHB':Decimal("-1000"),
'S-HKK':Decimal("0"),
'C-HKK':Decimal("0"),
},
'AI': {
'T-UD':Decimal("45"),
'T-FHK':Decimal("35"),
'T-FHM':Decimal("35"),
'I-FHK':Decimal('35'),
'T-USB':Decimal("45"),
'I-USB':Decimal("45"),
'T-UHB':Decimal("45"),
'I-UHB':Decimal("45"),
'S-HKK':Decimal("30"),
'C-HKK':Decimal("30"),
},
'AP': {
'T-UD':Decimal("1"),
'T-FHK':Decimal("1"),
'T-FHM':Decimal("1"),
'I-FHK':Decimal('2'),
'T-USB':Decimal("1"),
'I-USB':Decimal("2"),
'T-UHB':Decimal("1"),
'I-UHB':Decimal("2"),
'S-HKK':Decimal("0"),
'C-HKK':Decimal("0"),
},
'OP': {
'T-UD':Decimal("62"),
'T-FHK':Decimal("62"),
'T-FHM':Decimal("62"),
'I-FHK':Decimal('62'),
'T-USB':Decimal("62"),
'I-USB':Decimal("62"),
'T-UHB':Decimal("62"),
'I-UHB':Decimal("62"),
'S-HKK':Decimal("44"),
'C-HKK':Decimal("44"),
},
}
