%% Example 2 from ACC 2012 paper

% Define plant

clear all;
close all;

s = tf('s');
P = ss(500/(s^2+s));

% Define controller

K = 0.96;
Td = 0.049;
Ti = 0.12;
N = 5;
h1 = 0.012;
C = -ss((K*(1+1/(Ti*s)+Td*s/(1+Td*s/N))))
[gm,pm,wcg,wcp] = margin(-C*P)
Cd1 = c2d(C,h1,'prewarp',wcp);

% Calculate output jitter margin for L=0.0056 using theorem by Kao and Lincoln

Pd1 = c2d(P,h1);
ams = allmargin(-Cd1*Pd1)
Dm1 = min(ams.DelayMargin*h1)
disp(['Delay margin: ' num2str(Dm1)]);

Pdelay = P;
Jm1 = calcdelaymargin(Pdelay,-Cd1);
disp(['Jitter margin: ' num2str(Jm1)])

% Find output jitter margin for L=0.0056 using theorem from ACC 2012 paper


%perf = jitterwcperf(P,Cd1,0.0056,Ji,Jo)


%Ji = 0.0099

Ji = linspace(0,0.004,12)

Ji = [Ji 0.004] 

%Jo = 0.0112

Jo = linspace(0,0.006,12)

Jo = [Jo 0.006] 

Hinf = zeros(1,12);

for i=1:length(Ji)
    perf = jitterwcperf(P,Cd1,0.0056,Ji(i),Jo(i))   
    Hinf(i) = perf;
    plot([0 Ji(i)],[Jo(i) 0],'-bs','MarkerSize',5,'LineWidth',1)
    hold on
    text(Ji(i)/1.96,Jo(i)/1.96,num2str(Hinf(i)))
end
