import os
import io

def readfrom_cpalmodel():
    inputfolder = str(os.path.dirname(os.path.abspath(__file__)))[:-8] + "analinta/cpal_model/"
    outputfile = str(os.path.dirname(os.path.abspath(__file__)))[:-8] + "analinta/inputs/taskSet.txt"
    writinglines = []
    for f in os.listdir(inputfolder):
        inputfile = inputfolder + f
        alldata = io.open(file=inputfile, mode='r').readlines()
        for line in alldata:
            if "Task" in line:
                content = line.split("Task{")[-1]
                content = content.split("}")[0]
                content = content.replace("\"", "")
                content = content.replace("\t", "")
                content = content.replace(" ", "")
                name = content.split(",")[0].split("=")[1]
                period = content.split(",")[1].split("=")[1]
                wcet = content.split(",")[2].split("=")[1]
                offset = content.split(",")[3].split("=")[1]
                deadline = content.split(",")[4].split("=")[1]
                writinglines.append(name + " " + deadline + " " + period + " " + wcet + " " + offset + " 0")
    taskSetold = io.open(file=outputfile, mode='rb').readlines()
    taskSetnew = io.open(file=outputfile, mode='wb')
    count = int(taskSetold[1]) + len(writinglines)
    taskSetold[1] = str(count) + "\n"
    for l in taskSetold:
        taskSetnew.write(str(l))
    for l in writinglines:
        taskSetnew.write("\n")
        taskSetnew.write(str(l))

def write_to_taskset():
    taskSetFile = str(os.path.dirname(os.path.abspath(__file__)))[:-8] + "analinta/inputs/taskSet.txt"
    taskSetold = io.open(file=taskSetFile, mode='r').read()
    print taskSetold
    taskSet = taskSetold.split("\n")
    taskSetnew = io.open(file=taskSetFile, mode='w')
    while True:
        count = int(taskSet[1])
        number = len(taskSet) - 2
        choice1 = raw_input("Task parameters for control task to be integrated : \n"
                            "         1. Deadline Di \n")
        choice2 = raw_input("         2. Task period Ti \n")
        choice3 = raw_input("         3. Execution time Ci \n")
        choice4 = raw_input("         4. Offset Oi \n")
        taskSet.append(str(str(number) + " " + choice1 + " " + choice2 + " " + choice3 + " " + choice4 + " 0"))
        count += 1
        taskSet[1] = str(count)
        breakcondition = raw_input(
            "Do you want to analyze another control task? (y or n)")
        if breakcondition == "n":
            break
    taskSetnew.write("\n".join(taskSet))

print "--------------------------------------------------------------------------------"
print "                                   CPAL4CPS             "

	
def run_rtanalyzer():

	exe_file = str(os.path.dirname(os.path.abspath(__file__)))[:-8] + "analinta/bin/rtAnalyser.exe"
	taskSetFile = str(os.path.dirname(os.path.abspath(__file__)))[:-8] + "analinta/inputs/taskSet.txt"
	cmd = exe_file + " -ts " + taskSetFile + " -vvv"
	os.system(cmd)

print "--------------------------------------------------------------------------------"
print "			ANALysis of INtegrated Task (ANALINTA)"
print "		Composite Contract Analysis for Real-time Control Tasks"
print "--------------------------------------------------------------------------------"

choice = raw_input("Select the computing mode:\n"
                   "         type '1' for Task parameters from Existing system (CPAL system model) \n"
                   "         type '2' for Integrating control task Schedulability analysis \n"
                   "         type '3' for running Stability analysis  \n"  # add Base Config
                   "         type '4' for running Evaluation Event Order \n"
                   "         type '5' for running OOF \n"
                   "         type '6' for running OOM \n"
                   "         type '7' for running Tasks \n")

exe_file = "../bin/rtAnalyser"

if choice == '1':
    readfrom_cpalmodel()

elif choice == '2':
    write_to_taskset()
    run_rtanalyzer()

elif choice == '3':
    DEFAULTTASKSETS = "10000"
    print "Compute results for base configuration"
    for PERIODTYPE in ["lHarmonic", "harmonic", "random"]:
        cmd = exe_file + " -def config -taskSets " + DEFAULTTASKSETS + " -periodType " + PERIODTYPE + " -opt " \
              + str(1000) + " -o ../results/results_" + PERIODTYPE + " -v"
        os.system(cmd)
    print "Done"

elif choice == '4':
    DEFAULTTASKSETS = "100"
    print "Compute results for base configuration"
    for PERIODTYPE in ["lHarmonic", "harmonic"]:
        cmd = exe_file + " -def config -taskSets " + DEFAULTTASKSETS + " -periodType " + PERIODTYPE + " -opt " \
              + str(1000) + " -o ../results/results_" + PERIODTYPE + " -v -evalEventOrder 1000 0 0.5 -utilSteps 0.1"
        os.system(cmd)
    print "Done"

elif choice == '5':
    DEFAULTTASKSETS = "1000"
    for PERIODTYPE in ["random", "lHarmonic", "harmonic"]:
        WENAME = "../results/res_" + PERIODTYPE + "_gran_we"
        os.system("echo \"\" " + WENAME)
        for GRAN in [1, 10, 50, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000]:
            cmd = exe_file + " -def config -taskSets " + DEFAULTTASKSETS + " -periodType " + PERIODTYPE + " -opt " \
                  + str(1000) + " -gran " + str(GRAN) + " -o ../tmp/res_" + PERIODTYPE + "_GRAN" + str(GRAN)
            print cmd
            os.system(cmd)
            FILENAME = "../tmp/res_" + PERIODTYPE + "_GRAN" + str(GRAN) + "_we"
            TEMPFile = "../ tmp / tmp"
            os.system("echo " + str(GRAN) + " > " + TEMPFile)
            os.system("paste " + str(TEMPFile) + " " + FILENAME + " >> " + WENAME)
            os.remove(TEMPFile)
    print "Done"

elif choice == '6':
    DEFAULTTASKSETS = "1000"
    for PERIODTYPE in ["random", "lHarmonic", "harmonic"]:
        WENAME = "../results/res_" + PERIODTYPE + "_oom_we"
        os.system("echo \"\" " + WENAME)
        for OOM in [1, 2, 3, 4, 5]:
            cmd = exe_file + " -def config -taskSets " + DEFAULTTASKSETS + " -periodType " + PERIODTYPE + " -opt " \
                  + str(1000) + " -oom " + str(OOM) + " -o ../tmp/res_" + PERIODTYPE + "_OOM" + str(OOM)
            print cmd
            os.system(cmd)
            FILENAME = "../tmp/res_" + PERIODTYPE + "_OOM" + str(OOM) + "_we"
            TEMPFile = "../ tmp / tmp"
            os.system("echo " + str(OOM) + " > " + TEMPFile)
            os.system("paste " + str(TEMPFile) + " " + FILENAME + " >> " + WENAME)
            os.remove(TEMPFile)
    print "Done"

elif choice == '7':
    DEFAULTTASKSETS = "1000"
    for PERIODTYPE in ["random", "lHarmonic", "harmonic"]:
        WENAME = "../results/res_" + PERIODTYPE + "_oom_we"
        os.system("echo \"\" " + WENAME)
        for TASKS in [2, 4, 6, 8, 10, 12, 14, 16, 18, 20]:
            cmd = exe_file + " -def config -taskSets " + DEFAULTTASKSETS + " -nrOfTasks " + str(
                TASKS) + " -periodType " + PERIODTYPE + " -opt " \
                  + str(1000) + " -o ../tmp/res_" + PERIODTYPE + "_" + str(TASKS)
            print cmd
            os.system(cmd)
            FILENAME = "../tmp/res_" + PERIODTYPE + "_" + str(TASKS) + "_we"
            TEMPFile = "../ tmp / tmp"
            os.system("echo " + str(TASKS) + " > " + TEMPFile)
            os.system("paste " + str(TEMPFile) + " " + FILENAME + " >> " + WENAME)
            os.remove(TEMPFile)
    print "Done"