function [UserRate,UserEE,UserEnergy]=FUN_Rate_and_EE(K,R,Q,H,P0,rho,c_rd)

rate_plus=zeros(1,K);
rate_minus=zeros(1,K);
UserRate=zeros(1,K);
UserEE=zeros(1,K);
UserEnergy=zeros(1,K);
for k=1:1:K,
    rate_plus(k)=log(det(R(:,:,k)+H(:,:,k,k)*Q(:,:,k)*H(:,:,k,k)'));
    rate_minus(k)=log(det(R(:,:,k)));
    UserRate(k)=real(rate_plus(k)-rate_minus(k));
    
    UserEnergy(k)=P0+rho*real(trace(Q(:,:,k)))+c_rd*UserRate(k)^2;
    
    UserEE(k)=UserRate(k)/UserEnergy(k);
end;