function [Pricing,Gradient_Plus,Gradient_Minus]=FUN_GradientMatrix_SEE(H,R,Q,K,EnergyConsumption)

for k=1:1:K,
    for j=1:1:K,
        Gradient_Plus(:,:,k,j)=H(:,:,j,k)'*((R(:,:,j)+H(:,:,j,j)*Q(:,:,j)*H(:,:,j,j)')^-1)*H(:,:,j,k);
        Gradient_Plus(:,:,k,j)=(Gradient_Plus(:,:,k,j)+Gradient_Plus(:,:,k,j)')/2;
        
        Gradient_Minus(:,:,k,j)=H(:,:,j,k)'*(R(:,:,j)^-1)*H(:,:,j,k);
        Gradient_Minus(:,:,k,j)=(Gradient_Minus(:,:,k,j)+Gradient_Minus(:,:,k,j)')/2;
    end;    
end;

for k=1:1:K,
    Pricing(:,:,k)=-(Gradient_Plus(:,:,k,k)-Gradient_Minus(:,:,k,k))/EnergyConsumption(k);
    for j=1:1:K,
        Pricing(:,:,k)=Pricing(:,:,k)+(Gradient_Plus(:,:,k,j)-Gradient_Minus(:,:,k,j))/EnergyConsumption(j);
    end;
    Pricing(:,:,k)=Pricing(:,:,k)*EnergyConsumption(k);
    Pricing(:,:,k)=(Pricing(:,:,k)+Pricing(:,:,k)')/2;
end;