function [Q]=FUN_WaterFilling(H,R,P,power)

% This function solves the following optimization problem:
% maximize  logdet(R+H*Q*H')+tr(P*Q)
% subject to Q>=0, tr(Q)<=P
%
% It is solved by waterfilling solution.

M_tx=length(H(1,:));

S=zeros(M_tx,M_tx);

mu_low=0; mu_high=100;
for k2=1:1:1000,
    mu=(mu_low+mu_high)/2;
    
    if mu_high-mu_low<10^-9,
        break;
    end;
    
    L1=(P-mu*eye(M_tx))^(-0.5);
    %     L1=L1^-1;
    [U1,D1]=eig((L1'*(H'*R^-1*H)*L1));
    D1=real(D1);
    
    for k1=1:1:M_tx,
        if D1(k1,k1)<=0,
            S(k1,k1)=0;
        elseif D1(k1,k1)>0,
            S(k1,k1)=max(1-1/D1(k1,k1),0);
        end;
    end;
    
    Q=(L1*(U1*S*U1')*L1');
    Q=(Q+Q')/2;
    
    if real(trace(Q))>power,
        mu_low=mu;
    end;
    
    if real(trace(Q))<power,
        mu_high=mu;
    end;
    
    
end;