function [Pricing,Gradient_Plus,Gradient_Minus]=FUN_GradientMatrix(H,R,Q,K)

% Gradient_Plus(:,:,k,j): the gradient of r+_j w.r.t. Q_k
% Gradient_Plus(:,:,k,k): the gradient of r_k w.r.t. Q_k

% Gradient_Minus(:,:,k,j): the gradient of r-_j w.r.t. Q_k
% Gradient_Minus(:,:,k,k): the gradient of r-_k w.r.t. Q_k, which is 0

M_tx=length(Q(:,:,1));
Gradient_Plus=zeros(M_tx,M_tx,K,K);
Gradient_Minus=zeros(M_tx,M_tx,K,K);
for k=1:1:K,
    for j=1:1:K,
        Gradient_Plus(:,:,k,j)=H(:,:,j,k)'*((R(:,:,j)+H(:,:,j,j)*Q(:,:,j)*H(:,:,j,j)')^-1)*H(:,:,j,k);
        Gradient_Plus(:,:,k,j)=(Gradient_Plus(:,:,k,j)+Gradient_Plus(:,:,k,j)')/2;
        
        Gradient_Minus(:,:,k,j)=H(:,:,j,k)'*(R(:,:,j)^-1)*H(:,:,j,k);
        Gradient_Minus(:,:,k,j)=(Gradient_Minus(:,:,k,j)+Gradient_Minus(:,:,k,j)')/2;
    end;    
    Gradient_Minus(:,:,k,k)=zeros(M_tx,M_tx);
end;

% Gradient_Plus-Gradient_Minus(:,:,k,j): the gradient of r_j w.r.t. Q_k
Pricing=zeros(M_tx,M_tx,K);
for k=1:1:K,
    Pricing(:,:,k)=-(Gradient_Plus(:,:,k,k)-Gradient_Minus(:,:,k,k));
    for j=1:1:K,
        Pricing(:,:,k)=Pricing(:,:,k)+(Gradient_Plus(:,:,k,j)-Gradient_Minus(:,:,k,j));
    end;
    Pricing(:,:,k)=(Pricing(:,:,k)+Pricing(:,:,k)')/2;
end;