set terminal postscript eps color enhanced;
set output 'SifsFrontStep1.eps'
set autoscale                        # scale axes automatically
set xtics font "Times Bold, 14"       # set xtics automatically
set ytics font "Times Bold, 14"        # set ytics automatically
set xlabel "Curvilinear coordinate along crack front [mm]" font "Times Bold, 20"
set ylabel "K_I [MPa{/Symbol @{\140\140\140}\326}mm ]" font "Times Bold, 20" 
set pointsize 2
set yrange [300:400]
set key spacing 1.5 font "Times, 20"
set tmargin 6
set bmargin 6
set rmargin 8
set lmargin 12
set key right bottom box

plot '1-FineMorfeo-smoothsifs.txt' u 2:7 title "Fixed fine mesh" w l lt 1 lc 1 lw 6,\
     '7-VeryCoarse-FC0-smoothsifs1.txt' u 2:7 title "Fixed very coarse mesh" w l lt 2 lc 3 lw 3,\
     '6-VeryCoarse-FC1-smoothsifs1.txt' u 2:7 title "Very coarse mesh - eng. adapt." w l lt 3 lc 2 lw 3,\
     '5-Coarse-FC1-smoothsifs1.txt' u 2:7 title "Coarse mesh - eng. adapt." w l lt 5 lc 5 lw 3,\
     '9-EqualDist-smoothsifs1.txt' u 2:7 title "Global + local EE adapt." w l lt 7 lc 7 lw 3,\
     '8-MinNum-smoothsifs1.txt' u 2:7 title "Min. number EE adapt." w l lt 1 lc 6 lw 3
     
     
     #     '4-Coarse-FC0-smoothsifs1.txt' u 2:7 title "Fixed coarse mesh" w l lt 4 lc 4 lw 3,\
