set terminal postscript eps color enhanced;
set output 'MeshNbrElmtsEvolution.eps'
set   autoscale                        # scale axes automatically
unset label                            # remove any previous labels
set xtics font "Times Bold, 14"       # set xtics automatically
set ytics font "Times Bold, 14"        # set ytics automatically
set xlabel "Iteration of the Error-control MA loop" font "Times Bold, 20"
set ylabel "Number of elements" font "Times Bold, 20"
set xrange [0:5]
set yrange [0:60000]
set pointsize 2
set key spacing 1.5 font "Times, 20"
set tmargin 6
set bmargin 6
set rmargin 8
set lmargin 12
set key top left Left box reverse

plot    "MeshNbrElmtsEvolution.txt" using 1:2 title "Global+Local" with linespoints ls 1,\
        "MeshNbrElmtsEvolution.txt" using 1:3 title "Global+Local (simplified)" with linespoints ls 2,\
        "MeshNbrElmtsEvolution.txt" using 1:4 title "Global+Local (vol. weighted)" with linespoints ls 3,\
        "MeshNbrElmtsEvolution.txt" using 1:5 title "Min-number" with linespoints ls 4,\
        "MeshNbrElmtsEvolution.txt" using 1:6 title "Uniform" with linespoints ls 5