set terminal postscript eps color enhanced;
set output 'plot_Error.eps'
set autoscale                        # scale axes automatically
set log                                                   
set xtics font "Times Bold, 14"       # set xtics automatically
set ytics font "Times Bold, 14"        # set ytics automatically
set xlabel "Mesh size(mm)" font "Times Bold, 20"
set ylabel "Energy norm error/energy norm" font "Times Bold, 20" 
set pointsize 2
set key spacing 1.5 font "Times, 20"
set tmargin 6
set bmargin 6
set rmargin 8
set lmargin 12
set object 1 poly from 0.004,0.03 to 0.006,0.03 to 0.006,0.045 to 0.004,0.03 fs empty border 1 # Red triangle
set key right bottom
set label "1" font "Times Bold, 12" at 0.005,0.0285
set label "1" font "Times Bold, 12" at 0.00605,0.0375
 
set object 2 poly from 0.0035,0.017 to 0.01,0.017 to 0.01,0.022 to 0.0035,0.022 to 0.0035,0.017 fs empty border 3 

plot    "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/Remesh.csv" using 1:2 title "Global + local" w p lt 9 lc 1,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/Remesh.csv" using 3:4 title "Global + local (simplified)" w p lt 9 lc 2,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/Remesh.csv" using 5:6 title "Global + local (vol. weighted)" w p lt 9 lc 3,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/Remesh.csv" using 9:10 title "Min. number" w p lt 9 lc 5,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/Remesh.csv" using 7:8 title "Uniform" w p lt 9 lc 4
        
