# Gnuplot script file for plotting data in file "Remesh.csv"
set terminal postscript eps color enhanced;
# set terminal epslatex color enhanced
set output 'TipError.eps'
set   autoscale                        # scale axes automatically
set log                             
unset label                            # remove any previous labels
set xtics font "Times Bold, 14"       # set xtics automatically
set ytics font "Times Bold, 14"        # set ytics automatically
# set title "Force Deflection Data for a Beam and a Column"
set xlabel "Mesh Size (mm)" font "Times Bold, 20"
set ylabel "Energy norm error/energy norm" font "Times Bold, 20" 
set xrange [0.004:0.4]
set yrange [0.00001:1.0]
set pointsize 2
set key spacing 1.8
set tmargin 6
set bmargin 6
set rmargin 8
set lmargin 12
set object 1 poly from 0.006,0.006 to 0.008,0.006 to 0.008,0.008 to 0.006,0.006 fs empty border 1
set object 2 poly from 0.01,0.0002 to 0.02,0.0002 to 0.02,0.0008 to 0.01,0.0002 fs empty border 3
set key right bottom 
# set label "Yield Point" at 0.003,260
# set arrow from 0.0028,250 to 0.003,280
#set xr [0.0:0.022]
# set yr [0:325]
set label "1" font "Times Bold, 12" at 0.007,0.0050
set label "1" font "Times Bold, 12" at 0.00805,0.007
set label "1" font "Times Bold, 12" at 0.015,0.00015
set label "2" font "Times Bold, 12" at 0.021,0.0005

plot    "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError3.csv" using 1:3 title "Tip element (exact)" with points lt 9 lc 1,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError1.txt" using 1:3 title "Enriched element (exact)" with points lt 11 lc 2,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError.csv" using 1:3 title "Simulation domain (exact)" with points lt 15 lc 5,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError3.csv" using 1:2 title "Tip element (estimated)" with points lt 8 lc 1,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError1.txt" using 1:2 title "Enriched element (estimated)" with points lt 10 lc 2,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError.csv" using 1:2 title "Simulation domain (estimated)" with points lt 14 lc 5
        #"EstimatedError2.csv" using 1:3 title "Non enriched element" with points lt 13 lc 4,\
        #"EstimatedError.csv" using 1:3 title "Simulation domain" with points lt 15 lc 5
#         "TipError.csv" using 5:6 title "Enriched zone" with points lt 7 lc 3,\
        
