set terminal postscript eps color enhanced;
set output 'DofsK1.eps'
set   autoscale                        # scale axes automatically
unset label                            # remove any previous labels
set xtics font "Times Bold, 14"       # set xtics automatically
set ytics font "Times Bold, 14"        # set ytics automatically
set xlabel "Dofs number" font "Times Bold, 20"
set ylabel "K_I relative error [-]" font "Times Bold, 20" 
set xrange [0.:130000]
set yrange [1e-5:1e-3]
set logscale y
set pointsize 2
set key spacing 1.5 font "Times, 20" box
set key right bottom 

plot    "DofsK1.txt" using 1:2 title "Global+local" with points lt 9 lc 1,\
        "DofsK1.txt" using 3:4 title "Global+local (simplified)" with points lt 9 lc 2,\
	"DofsK1.txt" using 5:6 title "Global+local (vol. weighted)" with points lt 9 lc 3,\
	"DofsK1.txt" using 9:10 title "Min. number" with points lt 9 lc 5,\
	"DofsK1.txt" using 7:8 title "Uniform" with points lt 9 lc 4
