set terminal postscript eps color enhanced;
set output 'plot_Effectivity_Sequence.eps'
set autoscale                        # scale axes automatically
set xtics font "Times Bold, 14"      # set xtics automatically
set ytics font "Times Bold, 14"      # set ytics automatically
set xlabel "Mesh adaptation increment" font "Times Bold, 20"
set ylabel "Effectivity" font "Times Bold, 20" 
set yrange [0.7:1.0]
set pointsize 2
set key spacing 1.5 font "Times, 20" box
set tmargin 6
set bmargin 6
set rmargin 8
set lmargin 12
set key right bottom

plot    "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EffectivitySequence.csv" using 1:2 title "Global + local" w p lt 9 lc 1,\
       "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EffectivitySequence.csv" using 1:3 title "Global + local (simplified)" w p lt 7 lc 5,\
       "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EffectivitySequence.csv" using 1:4 title "Global + local (vol. simplified)" w p lt 3 lc 3,\
       "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EffectivitySequence.csv" using 1:5 title "Min-number" w p lt 13 lc 7

        
