set terminal postscript eps color enhanced;
set output 'EffectivityTip.eps'
set   autoscale                        # scale axes automatically
unset label                            # remove any previous labels
set xtics font "Times Bold, 14"       # set xtics automatically
set ytics font "Times Bold, 14"        # set ytics automatically
set xlabel "Mesh Size (mm)" font "Times Bold, 20"
set ylabel "Effectivity index" font "Times Bold, 20" 
set xrange [0.01:0.1]
set yrange [0.2:1.0]
set logscale x
set pointsize 2
set key spacing 1.5 font "Times, 20"
set tmargin 6
set bmargin 6
set rmargin 8
set lmargin 12
set object 1 poly from 0.004,0.006 to 0.006,0.006 to 0.006,0.008 to 0.004,0.006 fs empty border 1
set object 2 poly from 0.01,0.0002 to 0.02,0.0002 to 0.02,0.0008 to 0.01,0.0002 fs empty border 3
set key right bottom 

plot    "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError3.csv" using 1:4 title "Tip element" with points lt 9 lc 1,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError1.txt" using 1:4 title "Enriched element" with points lt 11 lc 2,\
        "/home/pierard/Documents/papers/pierard/Jin_CMAME16/4-AfterReview/ArticleCorrection/pictures/EPS/EstimatedError.csv" using 1:4 title "Simulation domain" with points lt 15 lc 5
        
