function [r1pt, r1wt] = gaussQuad(quadorder)

r1pt = zeros(quadorder,1); 
r1wt = zeros(quadorder,1);

switch ( quadorder )
    case 1
        r1pt(1) = 0.000000000000000;
        r1wt(1) = 2.000000000000000;
        
    case 2
        r1pt(1) = 0.577350269189626;
        r1pt(2) =-0.577350269189626;
        
        r1wt(1) = 1.000000000000000;
        r1wt(2) = 1.000000000000000;
        
    case 3
        r1pt(1) = 0.774596669241483;
        r1pt(2) =-0.774596669241483;
        r1pt(3) = 0.000000000000000;
        
        r1wt(1) = 0.555555555555556;
        r1wt(2) = 0.555555555555556;
        r1wt(3) = 0.888888888888889;
        
    case 4
        r1pt(1) = 0.861134311594053;
        r1pt(2) =-0.861134311594053;
        r1pt(3) = 0.339981043584856;
        r1pt(4) =-0.339981043584856;
        
        r1wt(1) = 0.347854845137454;
        r1wt(2) = 0.347854845137454;
        r1wt(3) = 0.652145154862546;
        r1wt(4) = 0.652145154862546;
        
    case 5
        r1pt(1) = 0.906179845938664;
        r1pt(2) =-0.906179845938664;
        r1pt(3) = 0.538469310105683;
        r1pt(4) =-0.538469310105683;
        r1pt(5) = 0.000000000000000;
        
        r1wt(1) = 0.236926885056189;
        r1wt(2) = 0.236926885056189;
        r1wt(3) = 0.478628670499366;
        r1wt(4) = 0.478628670499366;
        r1wt(5) = 0.568888888888889;
        
    case 6
        r1pt(1) = 0.932469514203152;
        r1pt(2) =-0.932469514203152;
        r1pt(3) = 0.661209386466265;
        r1pt(4) =-0.661209386466265;
        r1pt(5) = 0.238619186003152;
        r1pt(6) =-0.238619186003152;
        
        r1wt(1) = 0.171324492379170;
        r1wt(2) = 0.171324492379170;
        r1wt(3) = 0.360761573048139;
        r1wt(4) = 0.360761573048139;
        r1wt(5) = 0.467913934572691;
        r1wt(6) = 0.467913934572691;
        
    case 7
        r1pt(1) =  0.949107912342759;
        r1pt(2) = -0.949107912342759;
        r1pt(3) =  0.741531185599394;
        r1pt(4) = -0.741531185599394;
        r1pt(5) =  0.405845151377397;
        r1pt(6) = -0.405845151377397;
        r1pt(7) =  0.000000000000000;
        
        r1wt(1) = 0.129484966168870;
        r1wt(2) = 0.129484966168870;
        r1wt(3) = 0.279705391489277;
        r1wt(4) = 0.279705391489277;
        r1wt(5) = 0.381830050505119;
        r1wt(6) = 0.381830050505119;
        r1wt(7) = 0.417959183673469;
        
    case 8
        r1pt(1) =  0.960289856497536;
        r1pt(2) = -0.960289856497536;
        r1pt(3) =  0.796666477413627;
        r1pt(4) = -0.796666477413627;
        r1pt(5) =  0.525532409916329;
        r1pt(6) = -0.525532409916329;
        r1pt(7) =  0.183434642495650;
        r1pt(8) = -0.183434642495650;
        
        r1wt(1) = 0.101228536290376;
        r1wt(2) = 0.101228536290376;
        r1wt(3) = 0.222381034453374;
        r1wt(4) = 0.222381034453374;
        r1wt(5) = 0.313706645877887;
        r1wt(6) = 0.313706645877887;
        r1wt(7) = 0.362683783378362;
        r1wt(8) = 0.362683783378362;
    case 9
        r1pt(1) = -0.968160239507626;
        r1pt(2) = -0.836031107326636;
        r1pt(3) = -0.613371432700590;
        r1pt(4) = -0.324253423403809;
        r1pt(5) =  0.000000000000000;
        r1pt(6) =  0.324253423403809;
        r1pt(7) =  0.613371432700590;
        r1pt(8) =  0.836031107326636;
        r1pt(9) =  0.968160239507626;
        
        r1wt(1) =  0.081274388361574;
        r1wt(2) =  0.180648160694857;
        r1wt(3) =  0.260610696402935;
        r1wt(4) =  0.312347077040003;
        r1wt(5) =  0.330239355001260;
        r1wt(6) =  0.312347077040003;
        r1wt(7) =  0.261610696402935;
        r1wt(8) =  0.180648160694857;
        r1wt(9) =  0.081274388361574;
    case 10
        r1pt(1)  = -0.973906528517172;
        r1pt(2)  = -0.865063366688985;
        r1pt(3)  = -0.679409568299024;
        r1pt(4)  = -0.433395394129247;
        r1pt(5)  = -0.148874338981631;
        r1pt(6)  =  0.148874338981631;
        r1pt(7)  =  0.433395394129247;
        r1pt(8)  =  0.679409568299024;
        r1pt(9)  =  0.865063366688985;
        r1pt(10) =  0.973906528517172;
        
        r1wt(1)  =  0.066671344308688;
        r1wt(2)  =  0.149451349150581;
        r1wt(3)  =  0.219086362515982;
        r1wt(4)  =  0.269266719309996;
        r1wt(5)  =  0.295524224714753;
        r1wt(6)  =  0.295524224714753;
        r1wt(7)  =  0.269266719309996;
        r1wt(8)  =  0.219086362515982;
        r1wt(9)  =  0.149451349150581;
        r1wt(10) =  0.066671344308688;
    case 12
        r1pt(1)  = -0.981560634246719;
        r1pt(2)  = -0.904117256370475;
        r1pt(3)  = -0.769902674194305;
        r1pt(4)  = -0.587317954286617;
        r1pt(5)  = -0.367831498998180;
        r1pt(6)  = -0.125233408511469;
        r1pt(7)  =  0.125233408511469;
        r1pt(8)  =  0.367831498998180;
        r1pt(9)  =  0.587317954286617;
        r1pt(10) =  0.769902674194305;
        r1pt(11) =  0.904117256370475;
        r1pt(12) =  0.981560634246719;
        
        r1wt(1)  =  0.047175336386512;
        r1wt(2)  =  0.106939325995318;
        r1wt(3)  =  0.160078328543346;
        r1wt(4)  =  0.203167426723066;
        r1wt(5)  =  0.233492536538355;
        r1wt(6)  =  0.249147045813403;
        r1wt(7)  =  0.249147045813403;
        r1wt(8)  =  0.233492536538355;
        r1wt(9)  =  0.203167426723066;
        r1wt(10) =  0.160078328543346;
        r1wt(11) =  0.106939325995318;
        r1wt(12) =  0.047175336386512;
    otherwise
        disp('Order of quadrature to high for Gaussian Quadrature');
        
end  % end of quadorder switch